<?php
/**
 * (c) 2023 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php

#sentry このコメント行は削除不可
# The above comment is for developers only.

/**
 * PassLogic Debug Mode
 */
define("DEBUG", 0);

/**
 * Multi-Tenant Mode
 */
require_once 'multitenant_setting.php';

/**
 * Directory Settings
 */
define('PHP_SELF', basename($_SERVER['SCRIPT_NAME']));
define('BASE_DIR', '/opt/passlogic');
define('TMP_DIR', BASE_DIR . '/tmp');
define('DATA_DIR', BASE_DIR . '/data');
define('CERT_DIR', DATA_DIR . '/conf/cert');
define('LICENSE_FILE', DATA_DIR . '/license-ent.asc');
define('APPS_DIR', BASE_DIR . '/apps');
define('LIB_DIR', APPS_DIR . '/lib');
define('CGI_DIR', APPS_DIR . '/cgi');
define('TOOLS_DIR', APPS_DIR . '/tools');
define('SSL_DIR', '/etc/pki/ssl');

/*
 *  Shared Definitions
 */
// Initial Administrator
define("INIT_ADMIN_UID", 'admin');

// Default Policy
define("DEFAULT_POLICY", 'Default Policy');

// [policy] PassClip authentication default value
define('PASSCLIP_DEFAULT_SLOT_NAME', 'PassLogic');
define('PASSCLIP_DEFAULT_DISPLAY_TYPE', '001');
define('PASSCLIP_DEFAULT_TIMESTEP', 30);
define('PASSCLIP_DEFAULT_DIGITS', 8);
define('PASSCLIP_SERVER_URL', 'https://appscheme-l.passclip.com/?mode=passlogic&query=');

// UserAgent判断文字列 / Browser Detection User Agent String
define('URL_HANDLER_SHOW', 'Android|iPhone|iPad');

// Loading Shared Modules
require_once(LIB_DIR . '/session.inc.php');
require_once(LIB_DIR . '/validator.inc.php');
require_once(LIB_DIR . '/form.inc.php');
require_once(LIB_DIR . '/util.inc.php');
require_once(LIB_DIR . '/crypt.inc.php');
require_once(LIB_DIR . '/database/passlogic_config.php');
require_once(LIB_DIR . '/model/admin_model.php');
require_once(LIB_DIR . '/model/user_model.php');
require_once(LIB_DIR . '/tenant_controller.php');
require_once(LIB_DIR . '/passlogic.inc.php');
require_once(LIB_DIR . '/passlogic_api_util.inc.php');
require_once(LIB_DIR . '/log.inc.php');
require_once(LIB_DIR . '/cert_util.inc.php');

//for rollback
define('IS_DIRECT_JUMP_REVERSE_PROXY', true);
// ログ閲覧画面の閲覧権限の設定。
// USERADMIN：useradminまで、OPERATOR：operatorまで、それ以外：adminのみ(デフォルト)。
define('ACCESS_CTRL_LOGLIST', '');
// ユーザIDの最大長
// パラメタ名: MAX_USER_ID_LENGTH
// 説明: ユーザIDの最大長を指定します。
//       管理画面では指定の文字数まで指定可能になり、
//       ui画面では、uidとして、[ユーザIDの最大長]@[ドメイン名の最大長]が指定できるようになります。
// 設定可能値: 1-64(1-64以外の値を指定した場合の動作は保証しません)
// デフォルト: 30
//define('MAX_USER_ID_LENGTH', '30');
// ドメイン名の最大長
// パラメタ名: MAX_DOMAIN_NAME_LENGTH
// 説明: ドメイン名の最大長を指定します。
//       管理画面では指定の文字数まで指定可能になります。
//       ui画面では、uidとして、[ユーザIDの最大長]@[ドメイン名の最大長]が指定できるようになります。
// 設定可能値: 1-64(1-64以外の値を指定した場合の動作は保証しません)
// デフォルト: 20
//define('MAX_DOMAIN_NAME_LENGTH', '20');
?>
