<?php
/**
 * (c) 2025 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php
 require_once '../config.inc.php'; require_once LIB_DIR . '/cert_util.inc.php'; class autopki extends Form { public $class_name; public function __construct() { global $uilang, $sess; $this->cert = new cert_util(); $this->class_name = get_class(); $this->uilang = $uilang; $this->passlogic_ui_lang = $uilang->get_current_lang(); $this->tmpl_path = TMPL_DIR . '/form/' . $this->class_name; $this->class_vars = array( 'uid', 'domain', 'serial', 'submit', 'cancel', ); $this->import($this->class_vars); $auth_ui = $sess->get_var(PRE_PL_AUTH_KEY); if (isset($auth_ui['autopki'])) { $this->uid = $auth_ui['uid']; $this->domain = $auth_ui['domain']; $this->tenant = $auth_ui['tenant']; } $this->serial = $sess->get_var('serial') ?? null; $this->permission_check(); if (!$this->action) { $this->action = 'form'; } } function permission_check() { global $tenant_controller; if ($tenant_controller->get_tenant() && !$tenant_controller->isMasterTenant()) { if (!$tenant_controller->check_permission('client_cert', $this->tenant)) { $this->disperror = 'PKI is unavailable.'; } } } public function form() { global $sess; $auth_ui = $sess->get_var(PRE_PL_AUTH_KEY); if (!$auth_ui) { $sess->unregister(PRE_PL_AUTH_KEY); header('Location: ./'); exit; } elseif (!$auth_ui['autopki']) { $sess->unregister(PRE_PL_AUTH_KEY); header('Location: ./'); exit; } $rootCA_set = $this->cert->getRootCA($this->tenant); if (!$rootCA_set) { $this->disperror = LANG_ERROR_PKI_UNSET; } return true; } public function confirm() { global $sess, $passlogic_config; $auth_ui = $sess->get_var(PRE_PL_AUTH_KEY); if ($this->cancel) { $sess->unregister(PRE_PL_AUTH_KEY); header('Location: ./'); exit; } if (!$auth_ui) { $sess->unregister(PRE_PL_AUTH_KEY); header('Location: ./'); exit; } elseif (!$auth_ui['autopki']) { $sess->unregister(PRE_PL_AUTH_KEY); header('Location: ./'); exit; } $pki_setting = $passlogic_config->get_config('PKI', 'default', $this->tenant); $user = new user_model($this->uid, $this->domain, $this->tenant); $user->select_from_db(); $config = $user->get_config(); $this->email = $user->get_userdata(array('uemail'))['uemail']; if ($auth_ui['autopki'] == 1) { $CL_set = $this->cert->generate_cert($this->uid, $this->domain, $this->tenant, $this->email, $config['autopki_CNSetting'], $config['autopki_expireDate']); $this->serial = $CL_set['serial']; $auth_ui['autopki'] = 2; $sess->register(PRE_PL_AUTH_KEY, $auth_ui); $sess->register('serial', $this->serial); } elseif ($auth_ui['autopki'] == 2) { $this->serial = $sess->get_var('serial'); $CL_set = $this->cert->getClientCA($this->serial, $this->tenant); } if ($pki_setting['download_limit']) { if ($pki_setting['download_limit'] <= $CL_set['downloadcount']) { $this->downloadLimit = 1; $sess->unregister('serial'); } } $this->_mailbody = nl2br($this->_charescape($this->getPrint($CL_set['downloadkey'], $CL_set['cert_password'], $user, $config))); } public function done() { global $sess, $passlogic_config; $auth_ui = $sess->get_var(PRE_PL_AUTH_KEY); if (!$auth_ui || !$this->serial) { header('Location: ./'); exit; } if ($_POST['sub'] == 'sendmail') { $ret = $this->sendmail($this->serial); if ($ret) { $this->disply = $this->passlogic_ui_lang['ui_autopki_sendmsg']; } else { $this->disply = $this->passlogic_ui_lang['ui_autopki_errormsg']; } $this->action = 'confirm'; $this->confirm(); } elseif ($_POST['sub'] == 'download') { if (!($pki_setting = $passlogic_config->get_config('PKI', 'default', $this->tenant))) { return false; } $CL_set = $this->cert->getClientCA($this->serial, $this->tenant); $download_limit = $pki_setting['download_limit'] ?? null; if ($download_limit) { if ($download_limit <= $CL_set['downloadcount']) { $sess->unregister('serial'); return false; } } $this->cert->setDownloadCount($this->serial, $this->tenant); $pki_file = $this->cert->changeCA2PKCS12($CL_set, $CL_set['cert_password']); header('Pragma: private'); header('Content-Disposition: attachment; filename=client.pfx'); header('Content-Type: application/x-pkcs12; name=client.pfx'); header('Content-Length: ' . strlen($pki_file)); echo $pki_file; exit; } else { $sess->unregister(PRE_PL_AUTH_KEY); $sess->unregister('serial'); header('Location: ./'); exit; } } private function sendmail($serial) { global $plinc, $plLog; $params = array( 'type' => 'user', 'uid' => $this->uid, 'domain' => $this->domain, 'tenant' => $this->tenant, 'serial' => $serial, ); if (!$plinc->sendnotice('pki', $params)) { $plLog->log('31014', $this->uid, $this->domain, $this->tenant); return false; } return true; } private function getPrint($downloadkey, $cert_password, user_model $user, $config) { global $plinc; $userdata = $user->get_userdata(); $tmpl = $config['mailBody_pki']; if ($config['matrixrow']) { $matrixrow = $config['matrixrow']; } else { $matrixrow = 4; } if ($config['matrixcol']) { $matrixcol = $config['matrixcol']; } else { $matrixcol = 12; } if ($config['tacpCollabocode']) { $collabo_code = $config['tacpCollabocode']; } $params = array( 'uid' => $this->uid, 'domain' => $this->domain, 'p1' => $userdata['p1'], 'uname' => $this->_charescape($userdata['uname']), 'uemail' => $this->_charescape($userdata['uemail']), 'row' => $matrixrow, 'col' => $matrixcol, 'collabo_code' => $collabo_code, 'downloadkey' => $downloadkey, 'cert_password' => $cert_password, 'tenant' => $this->tenant, ); $mailbody = $plinc->getmailbody($tmpl, $params); return $mailbody; } } $form = new autopki(); $form->main(); 