<?php
/**
 * (c) 2023 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php
 define('API_MODE', 1); require_once('/opt/passlogic/apps/lib/settings/global_setting.php'); require_once(LIB_DIR . '/settings/server_setting.php'); require_once(LIB_DIR . '/validator.inc.php'); require_once(LIB_DIR . '/passlogic_api_util.inc.php'); require_once(LIB_DIR . '/log.inc.php'); require_once(LIB_DIR . "/database/databaseManager.inc.php"); require_once(LIB_DIR . "/database/passlogic_config.php"); class passlogic_api_inc { private $api_util; private $response_code; protected $postdata; function __construct() { $this->api_util = new passlogic_api_util(); $this->plLog = new PasslogicLog(); $this->response_code = $this->plLog->_get_log_xml(); $this->tenant_controller = new tenant_controller('api'); if (!defined('MAX_USER_ID_LENGTH')) { define('MAX_USER_ID_LENGTH', '30'); } if (!defined('MAX_DOMAIN_NAME_LENGTH')) { define('MAX_DOMAIN_NAME_LENGTH', '20'); } } public function main() { $log_options = array( 'host_ip' => $this->postdata['host_ip'], 'client_ip' => $this->postdata['client_ip'], 'client_ua' => $this->postdata['client_ua'], ); $this->api_util->set_logoptions($log_options); switch ($this->postdata['mode']) { case 'tokenkeyreq': $token = 1; case 'keyreq': $this->keyreq($token); break; case 'auth': $this->auth(); break; case 'udidcheck': $this->udidcheck(); break; case 'pkicheck': $this->pkicheck(); break; case 'chgpattern': $this->chgpattern(); break; case 'chgpas': $this->chgpas(); break; case 'pc_registercheck': $this->pc_registercheck(); break; case 'radauth': $this->radauth(); break; case 'radresponse': $this->radresponse(); break; case 'addtoken': $this->addtoken(); break; case 'deltoken': $this->deltoken(); break; case 'tokenlist': $this->tokenlist(); break; case 'win_keyreq': $this->win_keyreq(); break; case 'win_auth': $this->win_auth(); break; case 'win_offdata': $this->win_offdata(); break; case 'win_userpolicy': $this->win_userpolicy(); break; case 'win_issue_login_ticket': $this->win_issue_login_ticket(); break; case 'win_issue_passthrough_token': $this->win_issue_passthrough_token(); break; case 'userread': $this->userread(); break; case 'usercreate': $this->usercreate(); break; case 'useredit': $this->useredit(); break; case 'userdelete': $this->userdelete(); break; case 'usersearch': $this->usersearch(); break; case 'dbstatus': $this->dbstatus(); break; case 'middlewarestatus': $this->middlewarestatus(); break; case 'usercountstatus': $this->usercountstatus(); break; case 'dfstatus': $this->dfstatus(); break; case 'usermail': $this->usermail(); break; default: $response_array['code'] = '10099'; $this->makeResponse($response_array, $this->postdata['json']); break; } } private function is_associative_array($arr) { if (array_values($arr) === $arr) { return false; } else { return true; } } private function _validator($validate_rules) { $validator = new Validator(); if (!is_array($validate_rules)) { return false; } foreach ($validate_rules as $name => $valid) { if (!is_array($valid)) { return false; } foreach ($valid as $val) { $rule = $val['rule']; if (is_null($this->postdata[$name])) { $this->postdata[$name] = ""; } $ret = $validator->dispatchMethod($this->postdata[$name], $rule); if (!$ret[0]) { $params['error'] = $name . ':' . $ret['message']; $response_array = array('code' => $val['code'], 'data' => $params); $this->makeResponse($response_array, $this->postdata['json']); } } } } protected function makeResponse($response_array, $json) { $code = $response_array['code']; $code_param = $this->response_code[$code]; $data = $code_param; $data['data'] = $response_array['data']; if ($json) { $jsonstr = json_encode($data); header('Content-Type: application/json'); print $jsonstr; exit; } else { $xmlstr = '<?xml version="1.0" encoding="UTF-8"?>'; $xmlstr .= "\n"; $xmlstr .= '<PassLogic:Response xmlns:PassLogic="https://www.passlogy.com/xmlns/PassLogic">'; $xmlstr .= "\n"; $xmlstr .= $this->xml_builder($data); $xmlstr .= '</PassLogic:Response>'; header('Content-Type: application/xml'); print $xmlstr; exit; } } private function xml_builder($array, $key_name = NULL) { $xml = ''; if (is_array($array)) { if ($this->is_associative_array($array)) { foreach ($array as $key => $val) { if (is_array($val)) { if ($this->is_associative_array($val)) { $xml .= '<' . $key . '>'; $xml .= "\n"; $xml .= $this->xml_builder($val); $xml .= '</' . $key . '>'; $xml .= "\n"; } else { $xml .= $this->xml_builder($val, $key); } } else { $xml .= '<' . $key . '>'; $xml .= htmlspecialchars($val, ENT_QUOTES); $xml .= '</' . $key . '>'; $xml .= "\n"; } } } else { foreach ($array as $val) { if (is_array($val)) { if ($this->is_associative_array($val)) { $xml .= '<' . $key_name . '>'; $xml .= $this->xml_builder($val); $xml .= '</' . $key_name . '>'; $xml .= "\n"; } else { $xml .= $this->xml_builder($val, $key_name); } } else { $xml .= '<' . $key_name . '>'; $xml .= htmlspecialchars($val, ENT_QUOTES); $xml .= '</' . $key_name . '>'; $xml .= "\n"; } } } } else { $xml .= $array; } return $xml; } private function keyreq($token = NULL) { if ($token) { if ($this->postdata['udid']) { $udid = $this->postdata['udid']; $this->log_options['client_cookie'] = $udid; } } $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '52100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '52100', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '52100', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '52100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '52100', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '52100', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '52100', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '52100', ), ), ); $this->_validator($valid); if ($this->postdata['authtype'] == 'admin') { $user = new admin_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); } else { $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); } $response_array = $this->api_util->keyreq($user, $token, $udid); $this->makeResponse($response_array, $this->postdata['json']); } private function auth() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '54100', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '54100', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '54100', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '54100', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '54100', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '54100', ), ), 'password' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54100', ), 'Between' => array( 'rule' => array('Between', 1, 255), 'code' => '54100', ), ), 'stepcnt' => array( 'Numeric' => array( 'rule' => 'Numeric', 'code' => '54100', ), ), ); $this->_validator($valid); if ($this->postdata['authtype'] == 'admin') { $user = new admin_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); } else { $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); } $response_array = $this->api_util->auth($user, $this->postdata['password'], $this->postdata['stepcnt']); $this->makeResponse($response_array, $this->postdata['json']); } private function chgpattern() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '57100', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '57100', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '57100', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '57100', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '57100', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '57100', ), ), 'p1' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->chgpattern($user, $this->postdata['p1']); $this->makeResponse($response_array, $this->postdata['json']); } private function chgpas() { $valid = array( 'paset' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), ), 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '57100', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '57100', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '57100', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '57100', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '57100', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '57100', ), ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); if (in_array($this->postdata['paset'], array('setb', 'setc', 'setw'))) { $extra_valid = array( 'pl_cookie' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57101', ), ), 'pl_pos' => array( 'Required' => array( 'rule' => 'Required', 'code' => '57100', ), 'Fixpassword' => array( 'rule' => 'Fixpassword', 'code' => '57100', ), ), ); $this->_validator($extra_valid); } switch ($this->postdata['paset']) { case 'seta': $response_array = $this->api_util->chgpas_seta($user); break; case 'setb': $response_array = $this->api_util->chgpas_setb($user, $this->postdata['pl_pos'], $this->postdata['pl_cookie']); break; case 'setc' : $response_array = $this->api_util->chgpas_setc($user, $this->postdata['pl_pos'], $this->postdata['pl_cookie']); break; case 'setw': $response_array = $this->api_util->chgpas_setw($user, $this->postdata['pl_pos'], $this->postdata['pl_cookie']); break; default: $response_array = $this->api_util->chgpas_seta($user); break; } $this->makeResponse($response_array, $this->postdata['json']); } private function udidcheck() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54150' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '54150' ), 'Userid' => array( 'rule' => 'Userid', 'code' => '54150', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54150' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '54150' ), 'Domain' => array( 'rule' => 'Domain', 'code' => '54150', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '54150', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '54150', ), ), ); $this->_validator($valid); $response_array = $this->api_util->udidcheck($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant(), $this->postdata['udid']); $this->makeResponse($response_array, $this->postdata['json']); } private function pkicheck() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54100' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '54100' ), 'Userid' => array( 'rule' => 'Userid', 'code' => '54100', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54100' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '54100' ), 'Domain' => array( 'rule' => 'Domain', 'code' => '54100', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '54100', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '54100', ), ), ); $this->_validator($valid); if ($this->postdata['tenant'] == null) { $this->postdata['tenant'] = ''; } $response_array = $this->api_util->pkicheck($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant(), $this->postdata['client_cert']); $this->makeResponse($response_array, $this->postdata['json']); } private function addtoken() { $valid = array( 'serial' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60000' ), 'Between' => array( 'rule' => array('Between', 1, 32), 'code' => '60000' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '60000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '60000', ), ), 'seed' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60000' ), 'Between' => array( 'rule' => array('Between', 1, 255), 'code' => '60000' ) ), 'timestep' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60000' ), 'Numeric' => array( 'rule' => 'Numeric', 'code' => '60000' ), 'BetweenValue' => array( 'rule' => array('BetweenValue', 1, 300), 'code' => '60000' ) ), 'digit' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60000' ), 'Numeric' => array( 'rule' => 'Numeric', 'code' => '60000' ), 'BetweenValue' => array( 'rule' => array('BetweenValue', 1, 16), 'code' => '60000' ) ), ); $this->_validator($valid); $response_array = $this->api_util->addtoken($this->postdata['serial'], $this->tenant_controller->get_tenant(), $this->postdata['seed'], $this->postdata['timestep'], $this->postdata['digit']); $this->makeResponse($response_array, $this->postdata['json']); } private function deltoken() { $valid = array( 'serial' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60000' ), 'Between' => array( 'rule' => array('Between', 1, 32), 'code' => '60000' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '60000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '60000', ), ), ); $this->_validator($valid); $response_array = $this->api_util->deltoken($this->postdata['serial'], $this->tenant_controller->get_tenant()); $this->makeResponse($response_array, $this->postdata['json']); } private function tokenlist() { $valid = array( 'uid' => array( 'Between' => array( 'rule' => array('Between', 0, MAX_USER_ID_LENGTH), 'code' => '60000', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '60000', ), ), 'domain' => array( 'Between' => array( 'rule' => array('Between', 0, MAX_DOMAIN_NAME_LENGTH), 'code' => '60000', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '60000', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '60000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '60000', ), ), ); $this->_validator($valid); $response_array = $this->api_util->tokenlist($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant(), $this->postdata['all'], $this->postdata['expiry']); $this->makeResponse($response_array, $this->postdata['json']); } private function userread() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '50100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '50100', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '50100', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '50100', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '50100', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '50100', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '50100', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '50100', ), ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); if ($this->postdata['params']) { $params_array = explode(',', $this->postdata['params']); } $response_array = $this->api_util->userread($user, $params_array); $this->makeResponse($response_array, $this->postdata['json']); } private function usercreate() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '30000', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '30000', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '30000', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '30000', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30000', ), ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $keys = $user->get_keys(); foreach ($keys as $key) { if (isset($this->postdata[$key])) { $user->set_value($key, $this->postdata[$key]); } } $response_array = $this->api_util->usercreate($user); $this->makeResponse($response_array, $this->postdata['json']); } private function useredit() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '30000', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '30000', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '30000', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '30000', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30000', ), ), ); $this->_validator($valid); $has_params = false; $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $keys = $user->get_keys(); foreach ($keys as $key) { if (isset($this->postdata[$key])) { if (in_array($key, array('uid', 'domain'))) { continue; } $user->set_value($key, $this->postdata[$key]); $has_params = true; } } if (!$has_params) { $this->makeResponse(array('code' => '30013'), $this->postdata['json']); } $response_array = $this->api_util->useredit($user); $this->makeResponse($response_array, $this->postdata['json']); } private function userdelete() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000', ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '30000', ), 'Userid' => array( 'rule' => 'Userid', 'code' => '30000', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000', ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '30000', ), 'Domain' => array( 'rule' => 'Domain', 'code' => '30000', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30000', ), ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->userdelete($user); $this->makeResponse($response_array, $this->postdata['json']); } private function usersearch() { $valid = array( 'offset' => array( 'Numeric' => array( 'rule' => 'Numeric', 'code' => '30000' ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30000', ), ), ); $this->_validator($valid); $type = array('locked', 'uexpiry', 'udisabled', 'all'); if (!in_array($this->postdata['type'], $type)) { $this->makeResponse(array('code' => '30050'), $this->postdata['json']); } $response_array = $this->api_util->usersearch($this->postdata['type'], $this->postdata['offset'], $this->tenant_controller->get_tenant()); $this->makeResponse($response_array, $this->postdata['json']); } private function radauth() { $passlogic_config = new passlogic_config(getPDO()); foreach ($this->postdata as $key => $postdata) { $this->postdata[$key] = stripslashes($postdata); } $client = $passlogic_config->get_config('radius', $this->postdata['client_ip'], ''); if ($client['auth_attribute']) { $param_name = str_replace('-', '_', strtoupper($client['auth_attribute'])); $row_param_value = $this->postdata[$param_name]; if (strpos($row_param_value, '0x') === 0) { $param_value = pack('H*', substr($row_param_value, 2)); } else { $param_value = substr($row_param_value, 1, strlen($row_param_value) - 2); } $attribute_auth = array( 'key' => $client['auth_param'], 'value' => $param_value ); } $user_set = Util::uid_splitter($this->postdata['username']); if ($user_set) { $user = new user_model($user_set['uid'], $user_set['domain'], $user_set['tenant']); } else { $user = new user_model($this->postdata['username'], '', ''); } $response_array = $this->api_util->radauth($user, $this->postdata['client_ip'], $this->postdata['username'], $this->postdata['radius_flag'], $this->postdata['row_password'], $this->postdata['row_challenge'], $attribute_auth); if ($response_array['code'] === '80201') { print 'Tmp-String-0:=\'' . addslashes($response_array['data']['Tmp-String-0']) . '\''; if ($response_array['data']['attributes']) { foreach ($response_array['data']['attributes'] as $attribute) { print ', ' . $attribute['name'] . ':=\'' . addslashes($attribute['val']) . '\''; } } exit; } } private function radresponse() { foreach ($this->postdata as $key => $postdata) { $this->postdata[$key] = stripslashes($postdata); } $user_set = Util::uid_splitter($this->postdata['username']); if ($user_set) { $user = new user_model($user_set['uid'], $user_set['domain'], $user_set['tenant']); } else { $user = new user_model($this->postdata['username'], '', ''); } $response_array = $this->api_util->radresponse($user, $this->postdata['client_ip'], $this->postdata['username'], $this->postdata['radius_flag']); exit; } private function win_keyreq() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '52300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '52300' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '52300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '52300' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '52300', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '52300', ), ), ); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_keyreq($user, $this->postdata['pid']); $this->makeResponse($response_array, $this->postdata['json']); } private function win_auth() { $appinfo = filter_input(INPUT_SERVER, 'HTTP_X_APPINFO'); $version = preg_split('/\//', $appinfo)[1]; $authmethod = $this->postdata['authmethod'] ? $this->postdata['authmethod'] : ''; switch ($version) { case '3.0.0.0': case '2.0.2.0': case '2.0.1.0': case '2.0.0.0': switch ($authmethod) { case 'passlogic': default: $this->win_auth_passlogic(); break; case 'passclip': $this->win_auth_passclip(); break; case 'totp': $this->win_auth_totp(); break; case 'fixedpassword': $this->win_auth_fixed(); break; } break; default: $this->win_auth_passlogic(); break; } } private function win_auth_passlogic() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '54300' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '54300' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '54300', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '54300', ), ), 'password' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54300' ), 'Between' => array( 'rule' => array('Between', 1, 255), 'code' => '54300' ), ), 'pid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54300' ), 'Between' => array( 'rule' => array('Between', 32, 32), 'code' => '54300' ), ), ); $uuid = $this->postdata['uuid']; $uuid_rule = $uuid !== null ? ['uuid' => ['WindowsUuid' => ['rule' => 'WindowsUuid', 'code' => '54300']]] : []; $valid = array_merge($valid, $uuid_rule); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_auth_passlogic($user, $this->postdata['password'], $this->postdata['pid'], $uuid); $this->makeResponse($response_array, $this->postdata['json']); } private function win_auth_passclip() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '70300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '70300' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '70300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '70300' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '70300', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '70300', ), ), 'password' => array( 'Required' => array( 'rule' => 'Required', 'code' => '70300' ), 'Between' => array( 'rule' => array('Between', 1, 255), 'code' => '70300' ), ), 'pid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '70300' ), 'Between' => array( 'rule' => array('Between', 32, 32), 'code' => '70300' ), ), ); $uuid = $this->postdata['uuid']; $uuid_rule = $uuid !== null ? ['uuid' => ['WindowsUuid' => ['rule' => 'WindowsUuid', 'code' => '70300']]] : []; $valid = array_merge($valid, $uuid_rule); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_auth_passclip($user, $this->postdata['password'], $this->postdata['pid'], $uuid); $this->makeResponse($response_array, $this->postdata['json']); } private function win_auth_totp() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '60300' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '60300' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '60300', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '60300', ), ), 'password' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60300' ), 'Between' => array( 'rule' => array('Between', 1, 255), 'code' => '60300' ), ), 'pid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '60300' ), 'Between' => array( 'rule' => array('Between', 32, 32), 'code' => '60300' ), ), 'stepcnt' => array( 'Numeric' => array( 'rule' => 'Numeric', 'code' => '60300', ), ), ); $uuid = $this->postdata['uuid']; $uuid_rule = $uuid !== null ? ['uuid' => ['WindowsUuid' => ['rule' => 'WindowsUuid', 'code' => '60300']]] : []; $valid = array_merge($valid, $uuid_rule); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_auth_totp($user, $this->postdata['password'], $this->postdata['pid'], $this->postdata['stepcnt'], $uuid); $this->makeResponse($response_array, $this->postdata['json']); } private function win_auth_fixed() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '80500' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '80500' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '80500' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '80500' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '80500', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '80500', ), ), 'password' => array( 'Required' => array( 'rule' => 'Required', 'code' => '80500' ), 'Between' => array( 'rule' => array('Between', 1, 255), 'code' => '80500' ), ), 'pid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '80500' ), 'Between' => array( 'rule' => array('Between', 32, 32), 'code' => '80500' ), ), ); $uuid = $this->postdata['uuid']; $uuid_rule = $uuid !== null ? ['uuid' => ['WindowsUuid' => ['rule' => 'WindowsUuid', 'code' => '80500']]] : []; $valid = array_merge($valid, $uuid_rule); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_auth_fixed($user, $this->postdata['password'], $this->postdata['pid'], $uuid); $this->makeResponse($response_array, $this->postdata['json']); } private function win_offdata() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54500' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '54500' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54500' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '54500' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '54500', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '54500', ), ), 'seed' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54500' ), 'Between' => array( 'rule' => array('Between', 32, 32), 'code' => '54500' ), ), 'remains' => array( 'Numeric' => array( 'rule' => 'Numeric', 'code' => '54500' ), 'Between' => array( 'rule' => array('Between', 0, 5), 'code' => '54500' ), ), 'acquired' => array( 'Numeric' => array( 'rule' => 'Numeric', 'code' => '54500' ), 'Between' => array( 'rule' => array('Between', 0, 10), 'code' => '54500' ), ), 'pid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '54500' ), 'Between' => array( 'rule' => array('Between', 32, 32), 'code' => '54500' ), ), ); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_offdata($user, $this->postdata['seed'], $this->postdata['remains'], $this->postdata['acquired'], $this->postdata['pid']); $this->makeResponse($response_array, $this->postdata['json']); } private function win_userpolicy() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '51300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '51300' ) ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '51300' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '51300' ) ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '51300', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '51300', ), ), ); $this->_validator($valid); $ldap = new ldap($this->tenant_controller->get_tenant()); $ldap_conf = $ldap->get_ldapconfig($this->postdata['domain'], $this->tenant_controller->get_tenant()); if($ldap_conf['convertUidToLowercase']){ $this->postdata['uid'] = mb_strtolower($this->postdata['uid']); } $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->win_userpolicy($user); $this->makeResponse($response_array, $this->postdata['json']); } private function win_issue_login_ticket() { return $this->win_issue_passthrough_token(true); } private function win_issue_passthrough_token($with_issue_login_ticket = false) { $validor_rules = [ 'uid' => [ 'Required' => [ 'rule' => 'Required', 'code' => '51300' ], 'Between' => [ 'rule' => [ 'Between', 1, MAX_USER_ID_LENGTH ], 'code' => '51300' ] ], 'domain' => [ 'Required' => [ 'rule' => 'Required', 'code' => '51300' ], 'Between' => [ 'rule' => [ 'Between', 1, MAX_DOMAIN_NAME_LENGTH ], 'code' => '51300' ] ], 'tenant' => [ 'Between' => [ 'rule' => [ 'Between', 0, 50 ], 'code' => '51300', ], 'Tenant' => [ 'rule' => 'Tenant', 'code' => '51300', ], ], 'passthrough_token' => [ 'Required' => [ 'rule' => 'Required', 'code' => '51300' ], ], 'uuid' => [ 'Required' => [ 'rule' => 'Required', 'code' => '51300' ], ], ]; $this->_validator($validor_rules); $domain = $this->postdata['domain']; $tenant = $this->tenant_controller->get_tenant(); $ldap = new ldap($tenant); $ldap_conf = $ldap->get_ldapconfig($domain, $tenant); $uid = $ldap_conf['convertUidToLowercase'] ? mb_strtolower($this->postdata['uid']) : $this->postdata['uid']; $user = new user_model($uid, $domain, $tenant); $passthrough_token = $this->postdata['passthrough_token']; $uuid = $this->postdata['uuid']; $response_array = $this->api_util->win_issue_passthrough_token($user, $passthrough_token, $uuid, $with_issue_login_ticket); $this->makeResponse($response_array, $this->postdata['json']); } private function dbstatus() { $valid = array( 'db' => array( 'Required' => array( 'rule' => 'Required', 'code' => '10010' ), 'Numeric' => array( 'rule' => 'Numeric', 'code' => '10010' ), 'BetweenValue' => array( 'rule' => array('BetweenValue', 0, 1), 'code' => '10010' ), ), ); $this->_validator($valid); $response_array = $this->api_util->dbstatus($this->postdata['db']); $this->makeResponse($response_array, $this->postdata['json']); } private function middlewarestatus() { $valid = array( 'type' => array( 'Required' => array( 'rule' => 'Required', 'code' => '10010' ), ), ); $this->_validator($valid); $response_array = $this->api_util->middlewarestatus($this->postdata['type']); $this->makeResponse($response_array, $this->postdata['json']); } private function usercountstatus() { $valid = array( 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30200', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30200', ), ), ); $is_all = is_null($this->postdata['tenant']); $this->_validator($valid); $response_array = $this->api_util->usercountstatus($this->postdata['filter'], $is_all ? null : $this->postdata['tenant']); $this->makeResponse($response_array, $this->postdata['json']); } private function pc_registercheck() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30200' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '30200' ), 'Userid' => array( 'rule' => 'Userid', 'code' => '30200', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30200' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '30200' ), 'Domain' => array( 'rule' => 'Domain', 'code' => '30200', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30200', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30200', ), ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->tenant_controller->get_tenant()); $response_array = $this->api_util->pc_registercheck($user, $this->postdata['apikey']); $this->makeResponse($response_array, $this->postdata['json']); } private function dfstatus(){ $response_array = $this->api_util->dfstatus(); $this->makeResponse($response_array, $this->postdata['json']); } private function usermail() { $valid = array( 'uid' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000' ), 'Between' => array( 'rule' => array('Between', 1, MAX_USER_ID_LENGTH), 'code' => '30000' ), 'Userid' => array( 'rule' => 'Userid', 'code' => '30000', ), ), 'domain' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000' ), 'Between' => array( 'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH), 'code' => '30000' ), 'Domain' => array( 'rule' => 'Domain', 'code' => '30000', ), ), 'tenant' => array( 'Between' => array( 'rule' => array('Between', 0, 50), 'code' => '30000', ), 'Tenant' => array( 'rule' => 'Tenant', 'code' => '30000', ), ), 'subject' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000' ), ), 'format' => array( 'Required' => array( 'rule' => 'Required', 'code' => '30000' ) ), ); $this->_validator($valid); $user = new user_model($this->postdata['uid'], $this->postdata['domain'], $this->postdata['tenant']); $response_array = $this->api_util->usermail($user, $this->postdata['subject'], $this->postdata['format']); $this->makeResponse($response_array, $this->postdata['json']); } } ?>
