<?php
/**
 * (c) 2024 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php include(TMPL_DIR . "/html_header.ihtml.php") ?>
<?php require_once(LIB_DIR . '/javascript_context_bridge.php');?>

<script type="text/javascript">
	function get_download() {
		<?php
		if ($this->download_limit) {
			echo "alert('".LANG_CNT_DOWNLOAD_LIMIT."');";
		}
		?>
		postHiddenForm({
			action: '<?php echo PHP_SELF ?>',
			parameters: {
				sub: 'download',
				form_session_id: document.querySelector('input[name=form_session_id]').value,
				<?php if ($this->_oldfile) { ?>
					oldfile: '<?php echo javascript_context_bridge\to_safe_string($this->_oldfile); ?>',
				<?php } ?>
				startdate: '<?php echo javascript_context_bridge\to_safe_string($this->_startdate); ?>',
				starttime: '<?php echo javascript_context_bridge\to_safe_string($this->_starttime); ?>',
				enddate: '<?php echo javascript_context_bridge\to_safe_string($this->_enddate); ?>',
				endtime: '<?php echo javascript_context_bridge\to_safe_string($this->_endtime); ?>',
				search_uid: '<?php echo javascript_context_bridge\to_safe_string($this->_search_uid); ?>',
				search_domain: '<?php echo javascript_context_bridge\to_safe_string($this->_search_domain); ?>',
				search_code: '<?php echo javascript_context_bridge\to_safe_string($this->_search_code); ?>'
			}
		});
	}
</script>
<script src="js/jkl-calendar.js" type="text/javascript"></script>
<script>
	// startdate
	var cal1 = new JKL.Calendar("calid1", "<?php echo $this->class_name ?>", "startdate");
	// enddate
	var cal2 = new JKL.Calendar("calid2", "<?php echo $this->class_name ?>", "enddate");
</script>
<script>
	function timelist_show(id) {
		document.getElementById("timelist" + id).style.display = "";
	}

	function timelist_hide(id) {
		document.getElementById("timelist" + id).style.display = "none";
		if (id === 1) {
			document.getElementById("starttime").value = document.getElementById("starttimelist").value;
		} else {
			document.getElementById("endtime").value = document.getElementById("endtimelist").value;
		}
	}
</script>

<?php
if (isset($this->disperror)) {
	?>
	<span class="error-text"><?php echo $this->disperror ?></span>
	<?php
}
?>

<form name="<?php echo $this->class_name ?>" id="<?php echo $this->class_name ?>" action="<?php echo PHP_SELF ?>" method="POST">

	<table >
		<tr>
			<td>From: &nbsp;</td>
			<td>
				<?php echo $this->_text("startdate", $this->_startdate, array('js' => 'onClick="cal1.write();" onChange="cal1.getFormValue(); cal1.hide();"', "autocomplete" => "off"), "passlogic_css_text text_typeB"); ?>:
				<span id="calid1"></span>
				<?php echo $this->_text("starttime", $this->_starttime, array('js' => 'onClick="timelist_show(1);",', "autocomplete" => "off"), "passlogic_css_text text_typeB") ?>
				<span id="timelist1" style="display:none;">
					<?php echo $this->_select("starttimelist", $this->timelist, '', 'timelist_hide(1);') ?>
				</span>
			</td>
		</tr>
		<tr>
			<td>To: &nbsp;</td>
			<td>
				<?php echo $this->_text("enddate", $this->_enddate, array('js' => 'onClick="cal2.write();" onChange="cal2.getFormValue(); cal2.hide();"', "autocomplete" => "off"), "passlogic_css_text text_typeB") ?>:
				<span id="calid2"></span>
				<?php echo $this->_text("endtime", $this->_endtime, array('js' => 'onClick="timelist_show(2);"', "autocomplete" => "off"), "passlogic_css_text text_typeB") ?>
				<span id="timelist2" style="display:none;">
					<?php echo $this->_select("endtimelist", $this->timelist, '', 'timelist_hide(2);') ?>
				</span>
			</td>
		</tr>
		<tr>
			<td><?php echo LANG_USER_UID ?></td>
			<td><?php echo $this->_text("search_uid", $this->_search_uid, "", "passlogic_css_text text_typeA"); ?></td>
		</tr>
		<tr>
			<td><?php echo LANG_USER_DOMAIN ?></td>
			<td><?php echo $this->_text("search_domain", $this->_search_domain, "", "passlogic_css_text text_typeA"); ?></td>
		</tr>
		<tr>
			<td><?php echo LANG_LOG_CODE ?></td>
			<td><?php echo $this->_text("search_code", $this->_search_code, "", "passlogic_css_text text_typeA"); ?></td>
		</tr>
		<tr>
			<td colspan="2"><?php echo $this->_checkbox("oldfile", "1", $this->_oldfile, "", "", LANG_LOG_OLDFILE); ?></td>
		</tr>
	</table>

	<input type="submit" name="search" value="<?php echo LANG_CNT_SEARCH ?>">
	<input type="button" class="commonBtn" name="reload" value="<?php echo LANG_CNT_RELOAD ?>" onclick="location.href = '<?php echo PHP_SELF ?>'">
	<input type="button" class="commonBtn" name="download" value="<?php echo LANG_CNT_DOWNLOAD ?>" onclick="get_download();">
</form>

<br />

<?php
if (!$this->error) {
	print $this->pagelink->get_link();
?>
<table class="striped">
	<tr>
		<td>date</td>
		<td>uid</td>
		<td>domain</td>
		<td>level</td>
		<td>code</td>
		<td>message</td>
		<td>host ip</td>
		<td>client ip</td>
		<td>user agent</td>
		<td>client cookie</td>
		<td>admin id</td>
	</tr>
	<?php
	if (is_array($this->data)) {
		foreach ($this->data as $key => $val) {
			if (!$val) { continue; }
			?>
			<tr>
				<td><?php echo date("Y-m-d H:i:s", (int)$val['time']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['uid']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['domain']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['level']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['code']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['message']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['host_ip']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['client_ip']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['client_ua']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['client_cookie']) ?>&nbsp;</td>
				<td><?php echo (new Form())->_charescape($val['admin_id']) ?>&nbsp;</td>
			</tr>
			<?php
		}
	}
	?>

</table>
<?php
	print $this->pagelink->get_link();
}
?>

<?php include(TMPL_DIR . "/html_footer.ihtml.php") ?>
