<?php
/**
 * (c) 2025 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php
 require_once("../config.inc.php"); require_once("../config_auth.inc.php"); require_once(LIB_DIR . "/groups.inc.php"); require_once(LIB_DIR . "/proxy_setting_util.php"); require_once(LIB_DIR . "/sort_util.inc.php"); require_once LIB_DIR . '/cert_util.inc.php'; class menu extends Form { public $_domain; public $_DONT_OPEN_NEW_TAB_SSO; public $_kn; public $_sub; public $_uid; public $class_name; public $disp_message; public $domain; public $general_config; public $kn; public $lastauthdate; public $param_chg; public $passlimit; public $passlogic_ui_lang; public $passwd_chg; public $saml; public $saml_list; public $sslvpn; public $sslvpn_list; public $uexpiry; public $uid; public $uilang; public $webapp; public $webapp_list; public $webtoken; function __construct() { global $uilang, $sess, $user, $tenant_controller; $this->class_name = get_class(); $this->uilang = $uilang; $this->tmpl_path = TMPL_DIR . "/form/" . $this->class_name; $this->class_vars = array( 'sub', 'uid', 'kn', 'domain', 'submit', 'cancel' ); $this->import($this->class_vars); $this->passlogic_ui_lang = $uilang->get_current_lang(); $this->message = $this->passlogic_ui_lang['ui_locale'] == 'ja' ? 'message_ja' : 'message'; $sess->unregister("pl_ui_passwd"); $userdata = $user->get_userdata(); $config = $user->get_config(); $this->uid = $userdata['uid']; $this->domain = $userdata['domain']; if ($user->get_ustatus() === "passchg") { print $this->passlogic_ui_lang['ui_changepass_required']; header('Location: passwd.php'); exit; } elseif ($user->get_ustatus() === "passclip") { print $this->passlogic_ui_lang['ui_passclip_required']; header('Location: passclip.php'); exit; } elseif ($user->get_ustatus() === "passlogiclp") { print $this->passlogic_ui_lang['ui_passlogiclp_required']; header('Location: passlogiclp.php'); exit; } if ($sess->get_var('chgpasswd')) { print $this->passlogic_ui_lang['ui_changepass_required']; header('Location: passwd.php'); exit; } $arr = array( 'uid' => $this->uid, 'domain' => $this->domain, 'tenant' => $tenant_controller->get_tenant(), ); $downloadkey = $sess->get_var('downloadkey'); if ($downloadkey) { $sess->register(PRE_PL_AUTH_KEY, $arr); $sess->unregister(PL_AUTH_KEY); header('Location: certdownload.php'); exit; } $cert_api = new cert_util(); if ($config['pkicheck'] && $config['autopki'] && $config['autopki_timing'] == '1') { $certCount = $cert_api->getClientCount($this->uid, $this->domain, $tenant_controller->get_tenant()); if (!$certCount) { $arr['autopki'] = 1; $sess->register(PRE_PL_AUTH_KEY, $arr); $sess->unregister(PL_AUTH_KEY); header('Location: autopki.php'); exit; } elseif ($certCount == 1) { $serial = $cert_api->userData2serial($this->uid, $this->domain, $tenant_controller->get_tenant()); $downloadCount = $cert_api->getDownloadCount($serial, $tenant_controller->get_tenant()); if ($downloadCount === 0) { $sess->register('serial', $serial); $arr['autopki'] = 2; $sess->register(PRE_PL_AUTH_KEY, $arr); $sess->unregister(PL_AUTH_KEY); header('Location: autopki.php'); exit; } } } $jump = $sess->get_var('jump'); $sess->unregister('jump'); if ($jump == 'token') { $url = 'token.php'; header('Location: ' . $url); exit; } $this->setRemember(); $sso = $sess->get_var('sso'); $sess->unregister('sso'); if ($sso['sso-vpn'] ?? false) { print "<script type=\"text/javascript\">"; print "top.location.href = \"sso-vpn.php?target=" . urlencode($sso['sso-vpn']) . "\""; print "</script>"; exit; } else if ($sso['sso-webapp'] ?? false) { header('Location: sso-webapp.php?target=' . urlencode($sso['sso-webapp'])); exit; } else if ($sso['sso-saml'] ?? false) { header('Location: sso-saml.php?target=' . urlencode($sso['sso-saml'])); exit; } if (!$this->action) { $this->action = "done"; } } function done() { global $passlogic_config, $tenant_controller, $auth_ui, $user, $sess; $message = filter_input(INPUT_GET, 'message'); $userdata = $user->get_userdata(); $config = $user->get_config(); $this->general_config = $passlogic_config->get_config('general_config', 'default', $tenant_controller->get_targetTenant()); if (is_array($this->general_config)) { foreach ($this->general_config as $key => $val) { if (strcmp($key,'DONT_OPEN_NEW_TAB_SSO') == 0) { $this->{"_" . $key} = $this->_charescape($val); } } } if ($message == "passwd") { $this->disp_message = $this->passlogic_ui_lang['ui_changepwmesg4']; } elseif ($message == "passclip") { $this->disp_message = $this->passlogic_ui_lang['ui_passclip_activated']; } elseif ($message == "setpass_ok") { $this->disp_message = $this->passlogic_ui_lang['ui_setting_commit']; } elseif ($message == "setpass_ng") { $this->disp_message = $this->passlogic_ui_lang['ui_setting_fail']; } $usergroup = Groups::get_user_groups([$userdata['group1'] ?? null, $userdata['group2'] ?? null, $userdata['group3'] ?? null, $userdata['group4'] ?? null, $userdata['group5'] ?? null]); $ip_groups = $passlogic_config->get_config_list('ip_group', $tenant_controller->get_targetTenant()); $ip = rtrim($_SERVER['HTTP_X_IP_ADDR'] ? $_SERVER['HTTP_X_IP_ADDR'] : ''); if (!WEBTOKEN_DIPS) { if ($config['ifWebtoken'] == "1" && in_array('PassLogic', $config['authMethod'])) { $this->webtoken = true; } } $uagentsettinglist = $passlogic_config->get_config_list('uagent', $tenant_controller->get_targetTenant()); $uagentconf = []; if (is_array($uagentsettinglist)) { foreach ($uagentsettinglist as $uagetsetting) { $uagentconf[] = $uagetsetting['config']; } usort($uagentconf, sort_util::sort_in_asc("display_order")); } if (count((array)$uagentconf) > 0) { $this->sslvpn_list = array(); foreach ($uagentconf as $val) { $display_flag = true; $val['groups'] ??= []; if ($display_flag && $val['display_order'] == '0') { $display_flag = false; } if (!preg_match("/" . URL_HANDLER_SHOW . "/", $_SERVER['HTTP_USER_AGENT'])) { if ($val['auth_post']) { if (!preg_match("/^http(s?):/", $val['auth_post'])) { $display_flag = false; } } else { $display_flag = false; } } if ($display_flag) { $vpngroup = array_filter($val['groups'], 'strlen'); if ($vpngroup) { if (!array_intersect($usergroup, $vpngroup)) { $display_flag = false; } } } if ($display_flag) { $this->sslvpn_list[$val['path']] = $val['path']; } } } if (count((array)$this->sslvpn_list) > 0) { $this->sslvpn = true; } $proxysettinglist = $passlogic_config->get_config_list('proxy', $tenant_controller->get_targetTenant()); $proxyconf = []; if (is_array($proxysettinglist)) { foreach ($proxysettinglist as $proxysetting) { $proxyconf[] = $proxysetting['config']; } usort($proxyconf, sort_util::sort_in_asc("display_order")); } if (count((array)$proxyconf) > 0) { $this->webapp_list = array(); foreach ($proxyconf as $val) { $display_flag = true; $val['groups'] ??= []; if ($display_flag && $val['display_order'] == '0') { $display_flag = false; } if ($display_flag) { $proxygroup = array_filter($val['groups'], 'strlen'); if ($proxygroup) { if (!array_intersect($usergroup, $proxygroup)) { $display_flag = false; } } } if ($display_flag) { $proxy_ip_groups = array_filter($val['ip_groups'], 'strlen'); if ($proxy_ip_groups) { $display_flag = false; foreach ((array)$ip_groups as $ip_group) { if (in_array($ip_group['name'], $proxy_ip_groups)) { list($network, $mask_bit_len) = explode('/', $ip_group['config']['mask']); $host = 32 - $mask_bit_len; $net = ((ip2long($network) >> $host) << $host); $ip_net = ((ip2long($ip) >> $host) << $host); if ($net === $ip_net) { $display_flag = true; break; } } } } } if ($display_flag) { $this->webapp_list[] = $val; } } } if (count((array)$this->webapp_list) > 0) { $this->webapp = true; } $samlsettinglist = $passlogic_config->get_config_list('saml', $tenant_controller->get_targetTenant()); $splist = []; if (is_array($samlsettinglist)) { foreach ($samlsettinglist as $samlsetting) { $splist[] = $samlsetting['config']; } usort($splist, sort_util::sort_in_asc("display_order")); } if (count((array)$splist) > 0) { $this->saml_list = array(); foreach ($splist as $val) { $display_flag = true; $val['groups'] ??= []; if ($display_flag && $val['display_order'] == '0') { $display_flag = false; } if ($display_flag) { $spgroup = array_filter($val['groups'], 'strlen'); if ($spgroup) { if (!array_intersect($usergroup, $spgroup)) { $display_flag = false; } } } if ($display_flag) { $sp_ip_groups = array_filter($val['ip_groups'], 'strlen'); if ($sp_ip_groups) { $display_flag = false; foreach ((array)$ip_groups as $ip_group) { if (in_array($ip_group['name'], $sp_ip_groups)) { list($network, $mask_bit_len) = explode('/', $ip_group['config']['mask']); $host = 32 - $mask_bit_len; $net = ((ip2long($network) >> $host) << $host); $ip_net = ((ip2long($ip) >> $host) << $host); if ($net === $ip_net) { $display_flag = true; break; } } } } } if ($display_flag) { if ($val['relayStateURL']) { $this->saml_list[] = array( 'target' => $val['providerName'], 'url' => $val['relayStateURL'], 'initype' => $val['initype'], ); } else { $this->saml_list[] = array( 'target' => $val['providerName'], 'url' => $val['recipient'], 'initype' => $val['initype'], ); } } } } if (count((array)$this->saml_list) > 0) { $this->saml = true; } if (in_array('PassLogic', $config['authMethod'])) { if ($config['enableChangePassword'] !== '0') { $this->passwd_chg = true; } } if ($config['passChg'] == '1') { $a_vpnat_check = $config["a_vpnat_check"]; $a_vpnat_key = $config["a_vpnat_key"]; $a_vpnpa_check = $config["a_vpnpa_check"]; $a_vpnpa_key = $config["a_vpnpa_key"]; $a_webpa_check = $config["a_webpa_check"]; $a_webpa_key = $config["a_webpa_key"]; for ($i = 0; $i < 10; $i++) { if ($a_vpnat_check[$i] == 1) { if ($a_vpnat_key[$i] != '') { $this->param_chg = true; break; } } if ($a_vpnpa_check[$i] == 1) { if ($a_vpnpa_key[$i] != '') { $this->param_chg = true; break; } } if ($a_webpa_check[$i] == 1) { if ($a_webpa_key[$i] != '') { $this->param_chg = true; break; } } } if (!$this->param_chg) { $a_pass_check = $config["a_pass_check"]; $a_pass_key = $config["a_pass_key"]; for ($i = 0; $i < 5; $i++) { if ($a_pass_check[$i] == 1) { if ($a_pass_key[$i] != '') { $this->param_chg = true; break; } } } } if (in_array('PassClip', $config["authMethod"])) { $a_passclip_pin_check = $config["a_passclip_pin_check"]; $a_passclip_pin_key = $config["a_passclip_pin_key"]; if ($a_passclip_pin_check == 1) { if ($a_passclip_pin_key != '') { $this->param_chg = true; } } } if (in_array('TOTP', $config["authMethod"])) { $a_totp_pin_check = $config["a_totp_pin_check"]; $a_totp_pin_key = $config["a_totp_pin_key"]; if ($a_totp_pin_check == 1) { if ($a_totp_pin_key != '') { $this->param_chg = true; } } } } if ($config['dispBeforeLogin'] === '1') { if ($auth_ui['lastauthdate'] === '0' || $auth_ui['lastauthdate'] === 0 || $auth_ui['lastauthdate'] === NULL) { $this->lastauthdate = 'No data'; } else { $this->lastauthdate = date("Y/m/d H:i:s", $auth_ui['lastauthdate']); } } if ($config['dispUexpiry'] === '1') { if (($userdata['uexpiry'] === '0') or ( $userdata['uexpiry'] == 0)) { $this->uexpiry = $this->passlogic_ui_lang['ui_indefinite']; } else { $this->uexpiry = date("Y/m/d", $userdata['uexpiry']); } } if (in_array('PassLogic', $config['authMethod'])) { if ($config['isPasschgTimeup'] === 'false') { $passLimit = $this->passlogic_ui_lang['ui_indefinite']; } else { if ($config['dispPassLimit'] === '1') { $passdate = $userdata['passsetdate'] + $config['passchgtimeupdays']; $passLimit = date("Y/m/d", $passdate); } else if ($config['dispPassLimit'] === '2') { $expire = floor(($userdata['passsetdate'] + $config['passchgtimeupdays'] - time()) / (60 * 60 * 24)); if ($expire < 1) { $passLimit = '0 ' . $this->passlogic_ui_lang['ui_day']; } else { $passLimit = $expire . $this->passlogic_ui_lang['ui_day']; } } } if ($config['dispPassLimit'] === '1' || $config['dispPassLimit'] === '2') { $this->passlimit = $this->passlogic_ui_lang['ui_passwordLimit'] . "：" . $passLimit; } } if (MULTI_TENANT == 0) { if ($message == "passwd" || $message == "passclip" || $message == "setpass") { $mod_auth_column = array('group1', 'group2', 'group3', 'group4', 'group5', 'param1', 'param2', 'param3', 'param4', 'param5', 'param6', 'param7', 'param8', 'param9', 'param10'); $mod_auth_params = array_filter($user->get_userdata($mod_auth_column), function ($value) { return strlen($value) == mb_strlen($value, 'UTF-8'); }); $mod_auth_params['ustatus'] = $user->get_ustatus(); $sess->register('mod_auth_params', $mod_auth_params); } } } function setRemember() { global $auth_ui, $user; $userdata = $user->get_userdata(); $config = $user->get_config(); if ($config['isremember'] AND ! $_COOKIE[PL_REMEMBER_KEY]) { $remember_expiry = time() + $config['rememberexpiry']; $remember_id = ''; $length = 16; $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJLKMNOPQRSTUVWXYZ123456789'; for ($i = 0; $i < $length; ++$i) { $remember_id .= $chars[random_int(0, 60)]; } $user->setRemember($remember_id, serialize($auth_ui), $remember_expiry); $user->update_to_db(); $cookie_data = serialize(array('uid' => $userdata['uid'], 'domain' => $userdata['domain'], 'tenant' => $userdata['tenant'], 'remember_id' => $remember_id)); setcookie(PL_REMEMBER_KEY, $cookie_data, $remember_expiry, '', '', ini_get("session.cookie_secure"), true); } } } $form = new menu(); $form->main(); ?>
