<?php
/**
 * (c) 2024 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php include(TMPL_DIR."/html_header.ihtml.php")?>

<script src="js/jkl-calendar.js" type="text/javascript"></script>
<script type="text/javascript">
<?php if ($this->_policy === DEFAULT_POLICY) { ?>
	// 認証メソッド一覧
	var auth_method_arr = ["PassLogic"];
<?php } else { ?>
	// 認証メソッド一覧
	var auth_method_arr = JSON.parse('<?php echo json_encode($this->_authMethod); ?>');

	function make_auth_method_selector() {
		var auth_method_selector_arr = [];
		$.each(auth_method_arr, function (index, auth_method) {
			var auth_method_selector_html = '<select name="authMethod[]" onchange="select_authmethod(' + index + ');">';
			switch (auth_method) {
				case "PassLogic":
					auth_method_selector_html += '<option value="PassLogic" selected>PassLogic</option>';
					auth_method_selector_html += '<option value="PassClip">PassClip</option>';
					auth_method_selector_html += '<option value="TOTP">TOTP</option>';
					break;
				case "PassClip":
					auth_method_selector_html += '<option value="PassLogic">PassLogic</option>';
					auth_method_selector_html += '<option value="PassClip" selected>PassClip</option>';
					auth_method_selector_html += '<option value="TOTP">TOTP</option>';
					break;
				case "TOTP":
					auth_method_selector_html += '<option value="PassLogic">PassLogic</option>';
					auth_method_selector_html += '<option value="PassClip">PassClip</option>';
					auth_method_selector_html += '<option value="TOTP" selected>TOTP</option>';
					break;
			}
			auth_method_selector_html += '</select>';
			auth_method_selector_html += '</select>';
			if (index !== 0) {
				auth_method_selector_html += '<input type="button" class="commonBtn" value="<?php echo LANG_CNT_DELETE; ?>" onclick="authmethod_del(' + index + ')">';
			}
			auth_method_selector_arr.push(auth_method_selector_html);
		});
		$('#authMethod').html(auth_method_selector_arr.join('<BR><BR>'));
	}

	// 認証メソッド選択
	function select_authmethod(index){
		// 選択したメソッドをauth_method_arrに更新
		auth_method_arr[index] = $('select[name="authMethod[]"]').eq(index).val();
		chg_view();
	}
<?php } ?>

	// 認証メソッドに応じたViewの表示非表示設定
	function chg_view(){
		// 全表示リセット（非表示化）
		$('.passlogic_auth').css('display', 'none');
		$('.passclip_auth').css('display', 'none');
		$('.totp_auth').css('display', 'none');
		// 設定の表示非表示切り替え
		$.each(auth_method_arr, function (i, v) {
			var type = v.toLowerCase();
			$('.' + type + '_auth').css('display', 'table-row');
		});

		swap_slot_settings(); // スロットの登録回数上限位置を調整
	}

	// スロットの登録回数上限の表示位置を調整
	function swap_slot_settings(){
		// alert(auth_method_arr);
		// console.log("ログテストsoto ");
		// console.log(auth_method_arr[0]);
		const slot = document.querySelector('#passclip_slot_settings');
		const lp = document.querySelector('#passclip_lp_settings');
		const lp_check = document.querySelector('#passclip_login_protect_check');
		const bottom = document.querySelector('#bottom_auth_area');
		switch (auth_method_arr[0]) {
			case "PassLogic":
				// ログインプロテクト、配下にスロットの登録回数上限の順番にする
				lp.parentElement.insertBefore(lp, bottom);
				lp_check.parentElement.appendChild(document.createElement("BR"));
				lp_check.parentElement.appendChild(slot);
				slot.style.borderBottom = 'hidden'; // 下部罫線を非表示にする
				if (!lp_check.checked) {
					slot.style.display = 'none';
				}
				break;
			case "PassClip":
				// スロットの登録回数上限、ログインプロテクトの順番にする
				lp.parentElement.insertBefore(slot, bottom);
				lp.parentElement.insertBefore(lp, bottom);
				slot.style.borderBottom = 'none'; // 下部罫線を標準に戻す
				if (lp_check.parentElement.lastChild.tagName === "BR") {
					// ログインプロテクトの最後の要素が改行なら削除
					lp_check.parentElement.lastChild.remove(); //改行を削除
				}				
				break;
			case "TOTP":
				// 何もしない。
				break;
		}
	}

	function open_forbidden_patterns() {
		row_value = document.getElementById('matrixrow').value;
		if (isNaN(row_value)) {
			row = 4;
		} else {
			row = parseInt(row_value);
			if (row < 1 || row > 4) {
				row = 4;
			}
		}
		col_value = parseInt(document.getElementById('matrixcol').value);
		if (isNaN(col_value)) {
			col = 12;
		} else {
			col = parseInt(col_value);
			if (col < 1 || col > 16) {
				col = 12;
			}
		}
		window.open('open_forbidden_patterns.php?row=' + row + '&col=' + col, 'open_forbidden_patterns', 'width=640, height=360, menubar=no, toolbar=no, scrollbars=yes');
	}
	
	$(function () {
<?php if ($this->_policy !== DEFAULT_POLICY) { ?>
		make_auth_method_selector();
<?php } ?>
		chg_view();

		// チェックボックスによる表示非表示切り替え
		$('input[type="checkbox"]').change(function () {
			var type = $(this).attr("id");
			// 設定の表示非表示切り替え
			if ($(this).is(':checked')) {
				$('#' + type + '_disp').css('display', 'block');
			} else {
				$('#' + type + '_disp').css('display', 'none');
			}
		});
		
		// 有効期限切れお知らせメール送信表示非表示
		$('#isPasschgTimeup').change(function () {
			// 設定の表示非表示切り替え
			if ($(this).is(':checked')) {
				$('#passchg_timeup').css('display', 'none');
				$('#notice_passchg_days_1').prop('disabled', true);
				$('#notice_passchg_days_2').prop('disabled', true);
				$('#notice_passchg_hour').prop('disabled', true);
			} else {
				$('#passchg_timeup').css('display', 'block');
				$('#notice_passchg_days_1').prop('disabled', false);
				$('#notice_passchg_days_2').prop('disabled', false);
				$('#notice_passchg_hour').prop('disabled', false);
			}
		});
		
		// アカウントロック通知メールのメールアドレス入力欄有効切替
		$('input[type="radio"][name="lockedmail_to"]').change(function () {
			// 設定の表示非表示切り替え
			if ($(this).is(':checked')) {
				if ($(this).val() !== '2') {
					document.getElementById('lockedmail_address').disabled = true;
					document.getElementById('lockedmail_address').style.backgroundColor = 'rgb(220, 220, 220)';
				} else {
					document.getElementById('lockedmail_address').disabled = false;
					document.getElementById('lockedmail_address').style.backgroundColor = 'white';
				}
			}
		});

		let slot_check_sw = function () {
			var url_tmp = $('#passclip_slot_api_url').val();
			var num_tmp = $('#passclip_max_num_slot').val(); 
			return function() {
				function checked() {
					$('#passclip_slot_api_url').val(url_tmp);
					$('#passclip_max_num_slot').val(num_tmp);
				}
				function unchecked() {
					url_tmp = $('#passclip_slot_api_url').val();
					num_tmp = $('#passclip_max_num_slot').val();
					$('#passclip_slot_api_url').val('');
					$('#passclip_max_num_slot').val(''); 
				}
				return $('#passclip_max_num_slot_check').is(':checked') ? checked() : unchecked();
			};
		}();

		$('#passclip_max_num_slot_check').change(slot_check_sw);
		
		let login_protect_check_sw = function () {
			var url_tmp = $('#passclip_login_protect_url').val();
			var sid_tmp = $('#passclip_login_protect_sid').val(); 
			var bio_tmp = $('input[id="passclip_login_protect_bio"]').prop('checked');
			return function() {
				function checked() {
					$('#passclip_login_protect_url').val(url_tmp);
					$('#passclip_login_protect_sid').val(sid_tmp);
					$('input[id="passclip_login_protect_bio"]').prop('checked', bio_tmp);
					$('#passclip_slot_settings').css('display', 'table-row');
				}
				function unchecked() {
					url_tmp = $('#passclip_login_protect_url').val();
					sid_tmp = $('#passclip_login_protect_sid').val();
					bio_tmp = $('input[id="passclip_login_protect_bio"]').prop('checked');
					$('#passclip_login_protect_url').val('');
					$('#passclip_login_protect_sid').val(''); 
					$('input[id="passclip_login_protect_bio"]').prop('checked', false);
					if (auth_method_arr[0] === "PassLogic") {
						$('#passclip_slot_settings').css('display', 'none');
					}
				}
				return $('#passclip_login_protect_check').is(':checked') ? checked() : unchecked();
			};
		}();

		$('#passclip_login_protect_check').change(login_protect_check_sw);
		
		// webToken - パスワード変更ボタン表示設定の制御
		var webToken_check_sw = (function () {
			var passchg_tmp = $('input[id="showPasschg"]').prop('checked');
			return function() {
				function checked() {
					$('input[id="showPasschg"]').prop('checked', passchg_tmp);
					$('div[id="showPasschgDiv"]').css('display', 'block');
				}
				function unchecked() {
					passchg_tmp = $('input[id="showPasschg"]').prop('checked');
					$('input[id="showPasschg"]').prop('checked', false);
					$('div[id="showPasschgDiv"]').css('display', 'none');
				}
				return $('input[id="ifWebtoken"]').prop('checked') ? checked() : unchecked();
			};
		})();

		$('input[id="ifWebtoken"]').change(webToken_check_sw);

		// checkboxの初期状態に付随する初回動作トリガ
		$('input[type="checkbox"]').change();
		
		// radioの初期状態に付随する初回動作トリガ
		$('input[type="radio"]').change();
	});

	function send_passchg_mail_open(){
		var day_1 = document.getElementById('notice_passchg_days_1').value;
		var day_2 = document.getElementById('notice_passchg_days_2').value;
		var passchgdays = document.getElementById('passchgtimeupdays').value * 60 * 60 * 24;
		var policy = "<?php echo $this->_policy; ?>";
		var target_tenant = "<?php echo $this->_target_tenant; ?>";
		if(confirm("<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_MAIL_CONFIRM; ?>")) {
			 $.get("userPasschgMail.php", {policy: policy, target_tenant:target_tenant, day1: day_1, day2: day_2, passchgdays: passchgdays});
				alert("<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_MAIL_DIALOG1; ?>\n" +
						"<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_MAIL_DIALOG2; ?>");
		}
	}
</script>
<script>
// expired
var cal1 = new JKL.Calendar("calid", "<?php echo $this->class_name?>", "autopki_expireDate");
cal1.min_date = new Date();
</script>

<h4 class="configHeading"><?php echo LANG_USER_TAB_POLICY ?><?php echo '[' . $this->_policy . ']'; ?><?php echo $tenant_controller->get_targetTenant() ? '(' . $tenant_controller->get_targetTenant() . ')' : '' ?></h4>

<form name="<?php echo $this->class_name?>" id="<?php echo $this->class_name?>" method="post" action="<?php echo PHP_SELF?>">
<input type="hidden" name="action" value="confirm">

&nbsp;&nbsp;&nbsp;&nbsp;<span class="ess">(*)</span> <?php echo LANG_CNT_MANDATORY?>

<!--Policy-->
<table>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_GENERAL?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_AUTH_METHOD ?></th>
	<td>
		<?php
			if(isset($this->error['authMethod'])){
				print "<span class=\"error-text\">".$this->error['authMethod']."</span><br>\n";
			}
		?>
		<?php if($this->_policy === DEFAULT_POLICY) { ?>
		PassLogic<br>
		<?php echo LANG_CONFIG_AUTH_METHOD_DESC; ?>
		<input type="hidden" name="authMethod[]" value="PassLogic">
		<?php } else { ?>
		<span id="authMethod">
		</span>
		<?php } ?>
	</td>
</tr>

<?php if ($tenant_controller->isMasterTenant()) { ?>
<tr>
	<th><?php echo LANG_TENANT_PERMISSION ?></th>
	<td>
		<?php
			// ポリシー設定は「利用不可」不要
			echo $this->_select("permission", $tenant_controller->getTenantPermissionList(), $this->_permission);
		?>
	</td>
</tr>
<?php } ?>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_ERRORLIMIT?></th>
	<td>
		<?php echo $this->_text("errorLimit", $this->_errorLimit, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_ERRORLIMIT_DISC?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_UNTIL_UNLOCK?></th>
	<td>
		<?php echo $this->_text("untilUnlock", $this->_untilUnlock, "", "passlogic_css_text text_typeC"); ?>
		<?php echo $this->_checkbox("isUntilUnlock", "false", ($this->_isUntilUnlock=="false"?"checked":""), "", "", LANG_CONFIG_NOTUNLOCK); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_UNTIL_UNLOCK_DISC?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_BUSINESSHOUR?></th>
	<td>
		<?php
			if(isset($this->error['accesslimit_starthour'])){
				print "<span class=\"error-text\">".$this->error['accesslimit_starthour']."</span><br>\n";
			}
			elseif(isset($this->error['accesslimit_startmin'])){
				print "<span class=\"error-text\">".$this->error['accesslimit_startmin']."</span><br>\n";
			}
			elseif(isset($this->error['accesslimit_endhour'])){
				print "<span class=\"error-text\">".$this->error['accesslimit_endhour']."</span><br>\n";
			}
			elseif(isset($this->error['accesslimit_endmin'])){
				print "<span class=\"error-text\">".$this->error['accesslimit_endmin']."</span><br>\n";
			}
		?>
		<?php echo LANG_CONFIG_PASSLOGIC_BUSINESSHOUR_STARTTIME?>
			<select name="accesslimit_starthour" id="accesslimit_starthour">
			<?php foreach ($this->hour_arr AS $value => $label) {
								echo "<option value=$value";
								if ($value == $this->_accesslimit_starthour) echo " selected";
								echo ">$label</option>\n";
							}
			?>
			</select>:
			<select name="accesslimit_startmin" id="accesslimit_startmin">
			<?php foreach ($this->minsec_arr AS $value => $label) {
								echo "<option value=$value";
								if ($value == $this->_accesslimit_startmin) echo " selected";
								echo ">$label</option>\n";
							}
			?>
			</select>
		&nbsp;&nbsp;&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_BUSINESSHOUR_ENDTIME?>
			<select name="accesslimit_endhour" id="accesslimit_endhour">
			<?php foreach ($this->hour_arr AS $value => $label) {
								echo "<option value=$value";
								if ($value == $this->_accesslimit_endhour) echo " selected";
								echo ">$label</option>\n";
							}
			?>
			</select>:
			<select name="accesslimit_endmin" id="accesslimit_endmin">
			<?php foreach ($this->minsec_arr AS $value => $label) {
								echo "<option value=$value";
								if ($value == $this->_accesslimit_endmin) echo " selected";
								echo ">$label</option>\n";
							}
			?>
			</select>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_BUSINESSHOUR_DISC?>

		</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_udidcheck?></th>
	<td>
		<?php echo $this->_checkbox("udidcheck", 1, $this->_udidcheck, "", "", LANG_CONFIG_PASSLOGIC_udidcheck_DESC); ?>
		<br>
		<div id='udidcheck_disp'>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_COOKIEVALUE ?>
			<?php echo $this->_select("cookiefix", $this->cookiefix_arr, $this->_cookiefix); ?>
		</div>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PKICHECK ?></th>
	<td>
		<?php echo $this->_checkbox('pkicheck', 1, $this->_pkicheck, "", "", LANG_CONFIG_PASSLOGIC_PKICHECK_DESC); ?>
		<div id='pkicheck_disp'>
			<br>
			<?php echo $this->_checkbox('autopki', 1, $this->_autopki, "", "", LANG_CONFIG_PASSLOGIC_AUTOPKI); ?>
			<?php echo LANG_CONFIG_PASSLOGIC_AUTOPKI_DESC ?><br>
			<br>
			<div id='autopki_disp'>
				<?php echo LANG_CONFIG_PASSLOGIC_AUTOPKI_TIMING ?><br>
				<?php echo $this->_radio("autopki_timing", array('0' => LANG_CONFIG_PASSLOGIC_AUTOPKI_TIMING_AT_CREATEUSER, '1' => LANG_CONFIG_PASSLOGIC_AUTOPKI_TIMING_AT_FIRSTLOGIN), ($this->_autopki_timing ? $this->_autopki_timing : '0')); ?><br />
				<?php echo LANG_COMMON_NAME ?>:<br>
				<?php echo $this->_radio("autopki_CNSetting", array('0' => 'uid_domain', '1' => 'uid_domain_random'), ($this->_autopki_CNSetting ? $this->_autopki_CNSetting : '0')); ?><br />
				<?php echo LANG_VALIDITY_TO ?>:<br>
				<?php echo $this->_text('autopki_expireDate', $this->_autopki_expireDate, array('js' => 'onClick="cal1.write();" onChange="cal1.getFormValue(); cal1.hide();"'), "passlogic_css_text text_typeB"); ?>
				<div id="calid"></div>
			</div>
		</div>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_saveAdPassword?></th>
	<td>
		<?php echo $this->_checkbox("saveAdPassword", 1, $this->_saveAdPassword, "", "", LANG_CONFIG_PASSLOGIC_saveAdPassword_DESC); ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSWORD ?></th>
	<td>
		<?php echo $this->_checkbox("passChg", 1, $this->_passChg, "", "", LANG_CONFIG_PASSLOGIC_PASSWORD_DESC); ?>
		<br>
		<div id='passChg_disp'>
			<table>
			<tr>
				<td></td>
				<td align="center"><?php echo LANG_CONFIG_DISP ?></td>
				<td align="center"><?php echo LANG_CONFIG_PARAM ?></td>
			</tr>
			<?php
			for ($i = 0; $i < 10; $i++) {
				if ($i == 0) {
					print '<tr><th colspan="3">';
					print LANG_CONFIG_VPN_ALIST;
					print '</th></tr>';
				}
				print "<tr>\n";

				print "<td><label for=\"a_vpnat_check[$i]\" class=\"labelBefore\">";
				echo constant('LANG_CONFIG_VPN_ATTRIBUTE' . ($i+ 1));
				print "</label></td>\n";

				print "<td>\n";
				echo $this->_checkbox("a_vpnat_check[$i]", 1, $this->_a_vpnat_check[$i] ?? null);

				print "</td>\n";

				print "<td>\n";
				echo $this->_text("a_vpnat_key[$i]", $this->_a_vpnat_key[$i] ?? null, "", "passlogic_css_text text_typeA");
				print "</td>\n";

				print "</tr>\n";
			}
			for ($i = 0; $i < 10; $i++) {
				if ($i == 0) {
					print '<tr><th colspan="3">';
					print LANG_CONFIG_VPN_PLIST;
					print '</th></tr>';
				}
				print "<tr>\n";

				print "<td><label for=\"a_vpnpa_check[$i]\" class=\"labelBefore\">";
				echo constant('LANG_CONFIG_VPN_PARAM' . ($i+ 1));
				print "</label></td>\n";

				print "<td>\n";
				echo $this->_checkbox("a_vpnpa_check[$i]", 1, $this->_a_vpnpa_check[$i] ?? null);

				print "</td>\n";

				print "<td>\n";
				echo $this->_text("a_vpnpa_key[$i]", $this->_a_vpnpa_key[$i] ?? null, "", "passlogic_css_text text_typeA");
				print "</td>\n";

				print "</tr>\n";
			}
			if (!MULTI_TENANT) {
				for ($i = 0; $i < 10; $i++) {
					if ($i == 0) {
						print '<tr><th colspan="3">';
						print LANG_CONFIG_WEBAPP_LIST;
						print '</th></tr>';
					}
					print "<tr>\n";

					print "<td><label for=\"a_webpa_check[$i]\" class=\"labelBefore\">";
					echo constant('LANG_CONFIG_WEBAPP_PARAM' . ($i+ 1));
					print "</label></td>\n";

					print "<td>\n";
					echo $this->_checkbox("a_webpa_check[$i]", 1, $this->_a_webpa_check[$i] ?? null);

					print "</td>\n";

					print "<td>\n";
					echo $this->_text("a_webpa_key[$i]", $this->_a_webpa_key[$i] ?? null, "", "passlogic_css_text text_typeA");
					echo '<br>';
					echo $this->_checkbox("a_webpa_basic[$i]", 1, $this->_a_webpa_basic[$i] ?? null, "", "", LANG_CONFIG_WEBAPP_BASIC);
					print "</td>\n";

					print "</tr>\n";
				}
			}
				print '<tr><th colspan="3">';
				print LANG_CONFIG_USERINFO_GUIDE;
				print '</th></tr>';
				print "<tr class='passclip_auth'>\n";

				print "<td><label for=\"a_passclip_pin_check\" class=\"labelBefore\">";
				echo constant('LANG_CONFIG_PASSCLIP_PIN');
				print "</label></td>\n";

				print "<td>\n";
				echo $this->_checkbox("a_passclip_pin_check", 1, $this->_a_passclip_pin_check);

				print "</td>\n";

				print "<td>\n";
				echo $this->_text("a_passclip_pin_key", $this->_a_passclip_pin_key, "", "passlogic_css_text text_typeA");
				print "</td>\n";

				print "</tr>\n";

				print "<tr class='totp_auth'>\n";

				print "<td><label for=\"a_totp_pin_check\" class=\"labelBefore\">";
				echo constant('LANG_CONFIG_TOTP_PIN');
				print "</label></td>\n";

				print "<td>\n";
				echo $this->_checkbox("a_totp_pin_check", 1, $this->_a_totp_pin_check);

				print "</td>\n";

				print "<td>\n";
				echo $this->_text("a_totp_pin_key", $this->_a_totp_pin_key, "", "passlogic_css_text text_typeA");
				print "</td>\n";

				print "</tr>\n";
			for ($i = 0; $i < 5; $i++) {
				if ($i == 0) {
					print '<tr><th colspan="3">';
					print LANG_CONFIG_PASSWORD_GUIDE;
					print '</th></tr>';
				}
				print "<tr>\n";

				print "<td><label for=\"a_pass_check[$i]\" class=\"labelBefore\">";
				echo constant('LANG_CONFIG_PASSWORD' . ($i+ 1));
				print "</label></td>\n";

				print "<td>\n";
				echo $this->_checkbox("a_pass_check[$i]", 1, $this->_a_pass_check[$i] ?? null);

				print "</td>\n";

				print "<td>\n";
				echo $this->_text("a_pass_key[$i]", $this->_a_pass_key[$i] ?? null, "", "passlogic_css_text text_typeA");
				print "</td>\n";

				print "</tr>\n";
			}
			?>
			</table>
		</div>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_BEFORELOGIN?></th>
	<td>
		<?php echo $this->_checkbox('dispBeforeLogin', 1, $this->_dispBeforeLogin); ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_UEXPIRY?></th>
	<td>
		<?php echo $this->_checkbox('dispUexpiry', 1, $this->_dispUexpiry); ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_REMEMBER?></th>
	<td>
		<?php echo $this->_checkbox("isremember", 1, $this->_isremember, "", "", LANG_CONFIG_PASSLOGIC_DISP_REMEMBER_DESC); ?>
		<br>
		<div id='isremember_disp'>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_DISP_REMEMBER_EXPIRY ?>
			<?php echo $this->_text("rememberexpiry", $this->_rememberexpiry, "", "passlogic_css_text text_typeB"); ?>
		</div>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_LOCKEDMAIL?></th>
	<td>
		<?php echo LANG_CONFIG_PASSLOGIC_DISP_LOCKEDMAIL_DESC?><br>
		<?php echo LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_TO ?><br>
		<?php echo $this->_radio("lockedmail_to", array(LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_NONE,LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_USER,LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_ADDRESS), $this->_lockedmail_to); ?>
		<?php echo $this->_text("lockedmail_address", $this->_lockedmail_address, "", "passlogic_css_text text_typeA"); ?><br>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON ?></th>
	<td>
		<?php echo $this->_checkbox("ifWinLogon", 1, $this->_ifWinLogon, "", "", LANG_CONFIG_PASSLOGIC_WINLOGON_DESC); ?>
		<br>
		<div id="ifWinLogon_disp">
			<table>
			<tr>
			<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_AUTH_TYPE ?></th>
			<td><?php echo $this->_select('winAuthType', $this->winAuthType_arr, $this->_winAuthType); ?></td>
			</tr>
			<tr class="passlogic_auth">
			<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_EXPIRE_WARNING ?></th>
			<td><?php echo $this->_text("winExpireWarning", $this->_winExpireWarning, "", "passlogic_css_text text_typeC"); ?>&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_EXPIRE_WARNING_DESC ?></td>
			</tr>
			<tr>
			<tr class="passlogic_auth">
			<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_ALLOW_LIMIT ?></th>
			<td><?php echo $this->_text("winAllowLimit", $this->_winAllowLimit, "", "passlogic_css_text text_typeC"); ?>&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_ALLOW_LIMIT_DESC ?></td>
			</tr>
			<tr class="passlogic_auth">
			<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_MAX_OFFLINE ?></th>
			<td><?php echo $this->_text("winMaxOffline", $this->_winMaxOffline, "", "passlogic_css_text text_typeC"); ?>&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_MAX_OFFLINE_DESC ?></td>
			</tr>
			<tr class="passclip_auth">
			<th><?php echo LANG_CONFIG_ALLOW_OFFLINE_WINLOGON ?></th>
			<td><?php echo $this->_checkbox('winOfflineClip', 1, $this->winOfflineClip, "", "", LANG_CONFIG_ALLOW_OFFLINE_WINLOGON_DESC); ?></td>
			</tr>
			<tr class="totp_auth">
			<th><?php echo LANG_CONFIG_ALLOW_OFFLINE_WINLOGON ?></th>
			<td><?php echo $this->_checkbox('winOfflineTotp', 1, $this->winOfflineTotp, "", "", LANG_CONFIG_ALLOW_OFFLINE_WINLOGON_DESC); ?></td>
			</tr>
			<tr class="passlogic_auth">
			<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_WARN_OFFLINE ?></th>
			<td><?php echo $this->_text("winWarnOffline", $this->_winWarnOffline, "", "passlogic_css_text text_typeC"); ?>&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_WARN_OFFLINE_DESC ?></td>
			</tr>
			<tr>
			<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_MAX_RETRY ?></th>
			<td><?php echo $this->_text("winMaxRetry", $this->_winMaxRetry, "", "passlogic_css_text text_typeC"); ?>&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_MAX_RETRY_DESC ?></td>
			</tr>
			</table>
		</div>
	</td>

</tr>

<?php
// PassLogic認証のポリシー設定項目
?>
<tr class="passlogic_auth"><th colspan="2">&nbsp;</th></tr>
<tr class="passlogic_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_PASSLOGIC?></span></th>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_RANDVALIDPERIOD?></th>
	<td>
		<?php echo $this->_text("RandValidPeriod", $this->_RandValidPeriod, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_RANDVALIDPERIOD_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_OLDPASSCOUNT?></th>
	<td>
		<?php echo $this->_text("oldPassCount", $this->_oldPassCount, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_OLDPASSCOUNT_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th rowspan="2"><?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP?></th>
	<td>
		<?php echo $this->_text("passchgtimeupdays", $this->_passchgtimeupdays, "", "passlogic_css_text text_typeC"); ?>
		<?php echo LANG_CNT_DAYS?>
		<?php echo $this->_checkbox("isPasschgTimeup", "false", ($this->_isPasschgTimeup=="false"?"checked":""), "", "", LANG_CONFIG_UNLIMITED); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<td id="passchg_timeup">
		<div>
		<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_MAIL ?>
			<table>
				<tbody id="notice_mail">
					<tr>
						<th rowspan="2" style="border-bottom: 0;">
							<?php echo $this->_text("notice_passchg_days_1", $this->_notice_passchg_days_1, "", "passlogic_css_text text_typeC"); ?>
							<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_DAYS_BEFORE_1 ?> -
							<?php echo $this->_text("notice_passchg_days_2", $this->_notice_passchg_days_2, "", "passlogic_css_text text_typeC"); ?>
							<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_DAYS_BEFORE_2 ?>
						</th>
							<td>
								<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_EVERYDAY ?>
								<select name="notice_passchg_hour" id="notice_passchg_hour">
								<?php foreach ($this->hour_arr AS $value => $label) {
													echo "<option value=$value";
													if ($value == $this->_notice_passchg_hour) echo " selected";
													echo ">$label</option>\n";
												}
								?>
								</select>
							<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_HOUR ?><br>
							<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_DISC ?>
							</td>
					</tr>
					<tr>
						<td>
							<input type="button" class="passlogic_css_button commonBtn" name="send_passchg_mail" id="send_passchg_mail" value="<?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_MAIL_SUBMIT ?>" onclick="send_passchg_mail_open()">
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_PASSLIMIT ?></th>
	<td>
		<?php echo $this->_select('dispPassLimit', $this->dispPassLimit_arr, $this->_dispPassLimit); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_UPASSCHGFORCED?></th>
	<td>
		<?php echo $this->_select("passchgforced", $this->passchgforced_arr, $this->_passchgforced); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_UPASSCHGFORCED_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_CHANGE_PASSWORD ?></th>
	<td>
		<?php echo $this->_select("enableChangePassword", $this->enableChangePassword_arr, $this->_enableChangePassword); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_REQUIRE_CURRENT_PASSWORD ?></th>
	<td>
		<?php echo $this->_select("requireCurrentPassword", $this->requireCurrentPassword_arr, $this->_requireCurrentPassword); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_MATRIX_SIZE?></th>
	<td>
		<?php echo LANG_CONFIG_MATRIX_ROW?>
		<?php echo $this->_text2("matrixrow", $this->_matrixrow, "", "passlogic_css_text text_typeC"); ?>
		<?php echo LANG_CONFIG_MATRIX_COL?>
		<?php echo $this->_text2("matrixcol", $this->_matrixcol, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_MATRIX_SIZE_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_NOFIX_PASS?></th>
	<td>
		<?php echo LANG_CONFIG_MIN?>
		<?php echo $this->_text2("minOtpLength", $this->_minOtpLength, "", "passlogic_css_text text_typeC"); ?>
		<?php echo LANG_CONFIG_MAX?>
		<?php echo $this->_text2("maxOtpLength", $this->_maxOtpLength, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_NOFIX_PASS_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th rowspan="2"><?php echo LANG_CONFIG_PASSLOGIC_NOFIX_RANDOM_LENGTH?></th>
	<td>
		<?php echo $this->_text("randomOtpLength", $this->_randomOtpLength, "", "passlogic_css_text text_typeC"); ?><br>
		<?php echo LANG_CONFIG_PASSLOGIC_NOFIX_RANDOM_LENGTH_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<td>
		<?php echo $this->_checkbox("simpleOtp", "true", ($this->_simpleOtp == "true" ? true : false), "", "", LANG_CONFIG_PASSLOGIC_NOFIX_RANDOM_SIMPLE); ?>
		<?php echo LANG_CONFIG_PASSLOGIC_NOFIX_RANDOM_SIMPLE_DESC ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_FIX_PASS?></th>
	<td>
		<?php echo LANG_CONFIG_MIN?>
		<?php echo $this->_text2("minPinLength", $this->_minPinLength, "", "passlogic_css_text text_typeC"); ?>
		<?php echo LANG_CONFIG_MAX?>
		<?php echo $this->_text2("maxPinLength", $this->_maxPinLength, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_FIX_PASS_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_FIX_RANDOM_LENGTH?></th>
	<td>
		<?php echo $this->_text("randomPinLength", $this->_randomPinLength, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_FIX_RANDOM_LENGTH_DISC?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th rowspan="2"><?php echo LANG_CONFIG_PASSLOGIC_FORBIDDEN_PATTERNS?></th>
	<td>
		<?php echo $this->_checkbox("traversable", "true", ($this->_traversable == "true" ? true : false), "", "", LANG_CONFIG_PASSLOGIC_TRAVERSABLE_PATTERNS); ?>
		<?php echo $this->_checkbox("restricted_patterns", "true", ($this->_restricted_patterns == "true" ? true : false), "", "", LANG_CONFIG_PASSLOGIC_USE_ALL_BLOCKS); ?>
		<br><?php echo LANG_CONFIG_PASSLOGIC_ONE_PLACE?><br>
	</td>
</tr>
<tr class="passlogic_auth">
	<td>
		<?php echo LANG_CONFIG_PASSLOGIC_FORBIDDEN_PATTERNS_SUBTITLE ?>
		<div id="test">
			<table>
			<tbody id="forbiddenPatterns">
			<?php
			$i=0;
			if (count((array)$this->_forbiddenPatterns) > 0) {
				foreach ($this->_forbiddenPatterns as $key => $val) {
					print "<tr>\n";
					print "<td>\n";
					echo $this->_text("forbiddenPatterns[$i]", $val, "", "passlogic_css_text text_typeA");
					echo $this->_checkbox("delforbiddenPatterns[$i]", '1', "", "", "", LANG_CNT_DELETE);
					print "</td>";
					print "</tr>\n";

					$i++;
				}
			}
			?>
			</tbody>
			</table>
		</div>
		<input type="button" class="passlogic_css_button commonBtn" name="add_forbidden_patterns" id="add_forbidden_patterns" value="<?php echo LANG_CNT_ADD?>" onclick="open_forbidden_patterns()">
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_REMINDER ?></th>
	<td>
		<?php echo $this->_checkbox("passwordReminder", 1, $this->_passwordReminder, "", "", LANG_CONFIG_PASSLOGIC_REMINDER_DESC); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_WEBTOKEN ?></th>
	<td>
		<?php echo $this->_checkbox("ifWebtoken", 1, $this->_ifWebtoken, "", "", LANG_CONFIG_PASSLOGIC_WEBTOKEN_DESC); ?>
		<div id="showPasschgDiv">
			<?php echo $this->_checkbox("showPasschg", 1, $this->_showPasschg, "", "", LANG_CONFIG_PASSLOGIC_WEBTOKEN_SHOWPASSCHG_DESC); ?>
		</div>
	</td>
</tr>

<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_GUIDE ?></th>
	<td>
		<?php echo $this->_checkbox("ifGuide", 1, $this->_ifGuide, "", "", LANG_CONFIG_PASSLOGIC_GUIDE_DESC); ?>
	</td>
</tr>

<?php
// Passclip認証のポリシー設定項目
?>
<tr class="passclip_auth"><th colspan="2">&nbsp;</th></tr>
<tr class="passclip_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_PASSCLIP ?></span></th>
</tr>

<tr class="passclip_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_SLOT_NAME ?></th>
	<td>
		<?php echo $this->_text("passclip_slot_name", $this->_passclip_slot_name, "", "passlogic_css_text text_typeA"); ?>
	</td>
</tr>

<tr class="passclip_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_DISPLAY_TYPE ?></th>
	<td>
		<?php echo $this->_select("passclip_display_type", $this->passclipDisplayType_arr, $this->_passclip_display_type); ?>
	</td>
</tr>

<tr class="passclip_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_TIMESTEP ?></th>
	<td>
		<?php echo $this->_text("passclip_timestep", $this->_passclip_timestep, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_TIMESTEP_EXPLAIN ?>
	</td>
</tr>

<tr class="passclip_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_DIGITS ?></th>
	<td>
		<?php echo $this->_text("passclip_digits", $this->_passclip_digits, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_DIGITS_EXPLAIN ?>
	</td>
</tr>

<tr class="passclip_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_PIN_LENGTH ?></th>
	<td>
		<?php echo LANG_CONFIG_MIN?>
		<?php echo $this->_text("passclip_min_pin_length", $this->_passclip_min_pin_length, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_PIN_LENGTH_EXPLAIN ?>
	</td>
</tr>

<tr class="passclip_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_REQUIRE_CURRENT_PIN ?></th>
	<td>
		<?php echo $this->_select("passclip_require_current_pin", $this->passclip_require_current_pin_arr, $this->_passclip_require_current_pin); ?>
	</td>
</tr>

<tr class="passclip_auth passlogic_auth" id='passclip_slot_settings'>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_MAX_NUM_SLOT?></th>
	<td>
		<?php echo $this->_checkbox("passclip_max_num_slot_check", "true", ($this->_passclip_max_num_slot_check=="true"?"checked":""), "", "", LANG_CONFIG_PASSLOGIC_PASSCLIP_MAX_NUM_SLOT_EXPLAIN); ?>
		<br>
		<br>
		<div id='passclip_max_num_slot_check_disp'>
			<?php echo LANG_CONFIG_PASSLOGIC_SLOT_COUNT?></th>
			<br>
			<?php echo $this->_text("passclip_max_num_slot", $this->_passclip_max_num_slot, "", "passlogic_css_text text_typeC"); ?>
			<br>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_SLOT_API_URL?></th>
			<br>
			<?php echo $this->_text("passclip_slot_api_url", $this->_passclip_slot_api_url, "", "passlogic_css_text text_typeA"); ?>
		</div>
	</td>
</tr>

<tr class="passclip_auth passlogic_auth" id='passclip_lp_settings'>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT?></th>
	<td>
		<?php echo $this->_checkbox("passclip_login_protect_check", "true", ($this->_passclip_login_protect_check=="true"?"checked":""), "", "", LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_EXPLAIN); ?>
		<br>
		<div id='passclip_login_protect_check_disp'>
			<?php echo $this->_checkbox("passclip_login_protect_bio", "true", $this->_passclip_login_protect_bio, "", "", LANG_CONFIG_PASSLOGIC_PASSCLIP_BIO); ?>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_BIO_DESC ?>
			<br>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_URL?></th>
			<br>
			<?php echo $this->_text("passclip_login_protect_url", $this->_passclip_login_protect_url, "", "passlogic_css_text text_typeA"); ?>
			<br>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_SID?></th>
			<br>
			<?php echo $this->_text("passclip_login_protect_sid", $this->_passclip_login_protect_sid, "", "passlogic_css_text text_typeA"); ?>
		</div>
	</td>
</tr>

<?php
// TOTP認証のポリシー設定項目
?>
<tr class="totp_auth"><th colspan="2">&nbsp;</th></tr>
<tr class="totp_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_TOTP?></span></th>
</tr>

<tr class="totp_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_TOTP_TIMESHIFT1?></th>
	<td>
		<?php echo $this->_text('totpTimeShift1', $this->_totpTimeShift1, "", "passlogic_css_text text_typeC"); ?>
	</td>
</tr>

<tr class="totp_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_TOTP_TIMESHIFT2?></th>
	<td>
		<?php echo $this->_text('totpTimeShift2', $this->_totpTimeShift2, "", "passlogic_css_text text_typeC"); ?>
	</td>
</tr>

<tr class="totp_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_TOTP_PIN_LENGTH?></th>
	<td>
		<?php echo LANG_CONFIG_MIN?>
		<?php echo $this->_text('totpMinPinLength', $this->_totpMinPinLength, "", "passlogic_css_text text_typeC"); ?>
		<br>
		<?php echo LANG_CONFIG_PASSLOGIC_TOTP_PIN_LENGTH_EXPLAIN ?>
	</td>
</tr>

<tr class="totp_auth">
	<th><?php echo LANG_CONFIG_PASSLOGIC_REQUIRE_CURRENT_PIN ?></th>
	<td>
		<?php echo $this->_select("totpRequireCurrentPin", $this->totpRequireCurrentPin_arr, $this->_totpRequireCurrentPin); ?>
	</td>
</tr>

<tr id='bottom_auth_area'><th colspan="2">&nbsp;</th></tr>
</table>

<h4 class="configHeading"><?php echo LANG_USER_TAB_NOTICE ?></h4>
<!--UserInfo-->
<table>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_MAIL_ADDRESS_SETTINGS ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_FROM ?></th>
	<td>
		<?php echo $this->_text("mailFrom", $this->_mailFrom, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_CC ?></th>
	<td>
		<?php echo $this->_text("mailCc", $this->_mailCc, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BCC ?></th>
	<td>
		<?php echo $this->_text("mailBcc", $this->_mailBcc, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSLOGIC_NEW_USER ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject", $this->_mailSubject, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody", $this->_mailBody, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSLOGIC_REISSUE ?></span></th>
</tr>
<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_reissue", $this->_mailSubject_reissue, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_reissue", $this->_mailBody_reissue, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSLOGIC_REMINDER ?></span></th>
</tr>
<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_reminder", $this->_mailSubject_reminder, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_reminder", $this->_mailBody_reminder, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr class="passclip_auth passlogic_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSCLIP_SECRET ?></span></th>
</tr>
<tr class="passclip_auth passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_secret", $this->_mailSubject_secret, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr class="passclip_auth passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_secret", $this->_mailBody_secret, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr class="totp_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_TOTP_REPLACETOKEN ?></span></th>
</tr>
<tr class="totp_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_token", $this->_mailSubject_token, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr class="totp_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_token", $this->_mailBody_token, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_ACTIVATE ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_activate", $this->_mailSubject_activate, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_activate", $this->_mailBody_activate, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PKI ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text('mailSubject_pki', $this->_mailSubject_pki, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea('mailBody_pki', $this->_mailBody_pki, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr class="passlogic_auth">
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_EXPIRATION_DATE ?></span></th>
</tr>
<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_passchg", $this->_mailSubject_passchg, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr class="passlogic_auth">
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_passchg", $this->_mailBody_passchg, "", "textarea_typeD"); ?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_LOCKEDMAIL ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_text("mailSubject_lockedmail", $this->_mailSubject_lockedmail, "", "passlogic_css_text text_typeA");?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo $this->_textarea("mailBody_lockedmail", $this->_mailBody_lockedmail, "", "textarea_typeD"); ?>
	</td>
</tr>

</table>
<br>

<input type="submit" class="passlogic_css_submit" name="submit" value="<?php echo LANG_CNT_PROCEED?>">
<input type="hidden" name="sub" value="<?php echo $this->_sub?>">
<input type="hidden" name="policy" value="<?php echo $this->_policy?>">
<input type="hidden" name="policy_id" value="<?php echo $this->_policy_id?>">

</form>

<?php include(TMPL_DIR."/html_footer.ihtml.php")?>
