<?php
/**
 * (c) 2024 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php include(TMPL_DIR."/html_header.ihtml.php")?>

<h4 class="configHeading"><?php echo LANG_USER_TAB_POLICY ?><?php echo '[' . $this->_policy . ']'; ?><?php echo $tenant_controller->get_targetTenant() ? '(' . $tenant_controller->get_targetTenant() . ')' : '' ?></h4>

<!--Policy-->
<table>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_GENERAL?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_AUTH_METHOD?></th>
	<td>
		<?php
		echo implode('<BR><BR>', $this->_authMethod);
		?>
	</td>
</tr>

<?php if ($tenant_controller->isMasterTenant()) { ?>
<tr>
	<th><?php echo LANG_TENANT_PERMISSION?></th>
	<td>
		<?php echo $tenant_controller->getPermissionString($this->_permission) ?>
	</td>
</tr>
<?php } ?>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_ERRORLIMIT?></th>
	<td>
		<?php echo $this->_errorLimit?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_UNTIL_UNLOCK?></th>
	<td>
		<?php
		if ($this->_isUntilUnlock=="false") {
			print LANG_CONFIG_NOTUNLOCK;
		} else {
			print $this->_untilUnlock.' '.LANG_CNT_SECONDS;
		}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_BUSINESSHOUR?></th>
	<td>
	<?php
		if($this->_accesslimit_starthour == '--' && $this->_accesslimit_startmin == '--'
		&& $this->_accesslimit_endhour == '--' && $this->_accesslimit_endmin == '--'){
			print LANG_CONFIG_PASSLOGIC_BUSINESSHOUR_HOUR_NO;
		}
		else{
			print $this->hour_arr[$this->_accesslimit_starthour].":".$this->minsec_arr[$this->_accesslimit_startmin]."&nbsp;&nbsp;-&nbsp;&nbsp;";
			print $this->hour_arr[$this->_accesslimit_endhour].":".$this->minsec_arr[$this->_accesslimit_endmin];
		}
	?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_udidcheck?></th>
	<td>
		<?php
			if($this->_udidcheck){
				echo "ON<br>";
				echo LANG_CONFIG_PASSLOGIC_COOKIEVALUE;
				echo " : ";
				echo $this->cookiefix_arr[$this->_cookiefix];
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PKICHECK ?></th>
	<td>
		<?php
		if ($this->_pkicheck) {
			echo 'ON';
			if ($this->_autopki) {
		?>
				<br>
				<?php echo LANG_CONFIG_PASSLOGIC_AUTOPKI . ':ON'?><br>
				<?php echo LANG_CONFIG_PASSLOGIC_AUTOPKI_TIMING?>:<?php echo $this->autopki_timing != 1 ? LANG_CONFIG_PASSLOGIC_AUTOPKI_TIMING_AT_CREATEUSER : LANG_CONFIG_PASSLOGIC_AUTOPKI_TIMING_AT_FIRSTLOGIN?><br>
				<?php echo LANG_COMMON_NAME?>:<?php echo $this->autopki_CNSetting != 1 ? 'uid_domain' : 'uid_domain_random'?><br>
				<?php echo LANG_VALIDITY_TO?>:<?php echo $this->_autopki_expireDate?><br>
		<?php
			}
		} else {
			echo 'OFF';
		}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_saveAdPassword?></th>
	<td>
		<?php
			if($this->_saveAdPassword){
				echo "ON";
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSWORD ?></th>
	<td>
		<?php
			if ($this->passChg) {
				echo "ON";
				$f_tmp = 0;
				for ($i = 0; $i < 10; $i++) {
					$num = $i + 1;
					if (($this->a_vpnat_check[$i] ?? null) == 1 && ($this->a_vpnat_key[$i] ?? null) != '') {
						if ($f_tmp == 0) {
							echo "<br>";
							echo LANG_CONFIG_VPN_ALIST;
						}
						echo "<br>&nbsp;&nbsp;";
						echo constant('LANG_CONFIG_VPN_ATTRIBUTE' . $num) . " : {$this->_a_vpnat_key[$i]}";
						$f_tmp = 1;
					}
				}
				$f_tmp = 0;
				for ($i = 0; $i < 10; $i++) {
					$num = $i + 1;
					if (($this->a_vpnpa_check[$i] ?? null) == 1 && ($this->a_vpnpa_key[$i] ?? null) != '') {
						if ($f_tmp == 0) {
							echo "<br>";
							echo LANG_CONFIG_VPN_PLIST;
						}
						echo "<br>&nbsp;&nbsp;";
						echo constant('LANG_CONFIG_VPN_PARAM' . $num) . " : {$this->_a_vpnpa_key[$i]}";
						$f_tmp = 1;
					}
				}
				if (!MULTI_TENANT) {
					$f_tmp = 0;
					for ($i = 0; $i < 10; $i++) {
						$num = $i + 1;
						if (($this->a_webpa_check[$i] ?? null) == 1 && ($this->a_webpa_key[$i] ?? null) != '') {
							if ($f_tmp == 0) {
								echo "<br>";
								echo LANG_CONFIG_WEBAPP_LIST;
							}
							echo "<br>&nbsp;&nbsp;";
							echo constant('LANG_CONFIG_WEBAPP_PARAM' . $num) . " : {$this->_a_webpa_key[$i]}";
							if ($this->_a_webpa_basic[$i]) {
								echo '(*' . LANG_CONFIG_WEBAPP_BASIC . ')';
							}
							$f_tmp = 1;
						}
					}
				}
				$f_tmp = 0;
				for ($i = 0; $i < 5; $i++) {
					$num = $i + 1;
					if (($this->a_pass_check[$i] ?? null) == 1 && ($this->a_pass_key[$i] ?? null) != '') {
						if ($f_tmp == 0) {
							echo "<br>";
							echo LANG_CONFIG_PASSWORD_GUIDE;
						}
						echo "<br>&nbsp;&nbsp;";
						echo constant('LANG_CONFIG_PASSWORD' . $num) . " : {$this->_a_pass_key[$i]}";
						$f_tmp = 1;
					}
				}
				if ($this->a_passclip_pin_check == 1 && $this->a_passclip_pin_key != '') {
					echo "<br>&nbsp;&nbsp;";
					echo constant('LANG_CONFIG_PASSCLIP_PIN') . " : {$this->_a_passclip_pin_key}";
				}
				if ($this->a_totp_pin_check == 1 && $this->a_totp_pin_key != '') {
					echo "<br>&nbsp;&nbsp;";
					echo constant('LANG_CONFIG_TOTP_PIN') . " : {$this->_a_totp_pin_key}";
				}
			}
			else {
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_BEFORELOGIN?></th>
	<td>
		<?php
			if($this->_dispBeforeLogin){
				echo "ON";
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_UEXPIRY?></th>
	<td>
		<?php
			if($this->_dispUexpiry){
				echo "ON";
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_REMEMBER?></th>
	<td>
		<?php
			if($this->_isremember){
				echo "ON:";
				print $this->_rememberexpiry.' '.LANG_CNT_SECONDS;
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_LOCKEDMAIL?></th>
	<td>
		<?php echo LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_TO ?>
		<?php
			if($this->_lockedmail_to == 2){
				echo $this->_lockedmail_address;
			}elseif($this->_lockedmail_to == 1){
				echo LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_USER;
			}else{
				echo LANG_CONFIG_PASSLOGIC_LOCKEDMAIL_NONE;
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON ?></th>
	<td>
		<?php
			if($this->ifWinLogon){
				echo "ON";
		?>
		<table>
		<tr>
		<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_AUTH_TYPE ?></th>
		<td><?php echo $this->winAuthType_arr[$this->_winAuthType]; ?></td>
		</tr>
		<?php // <<< START ONLY PassLogic Authentication -------------------------------
		if(in_array('PassLogic', $this->_authMethod)){ ?>
		<tr>
		<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_EXPIRE_WARNING ?></th>
		<td><?php echo $this->winExpireWarning ?></td>
		</tr>
		<tr>
		<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_ALLOW_LIMIT ?></th>
		<td><?php echo $this->winAllowLimit ?></td>
		</tr>
		<tr>
		<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_MAX_OFFLINE ?></th>
		<td><?php echo $this->winMaxOffline ?></td>
		</tr>
		<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_WARN_OFFLINE ?></th>
		<td><?php echo $this->winWarnOffline ?></td>
		</tr>
		<?php } else { // ---------------------------- ONLY PassLogic Authentication END >>> ?>
		<tr>
		<th><?php echo LANG_CONFIG_ALLOW_OFFLINE_WINLOGON ?></th>
		<td>
			<?php
				if (($this->winMaxOffline == "0") || ($this->winMaxOffline == "")) {
					echo "OFF";
				} else {
					echo "ON";
				}
			?>
		</td>
		</tr>
		<?php } // ---------------------------- ONLY PassClip/TOTP Authentication END >>> ?>
		<tr>
		<th><?php echo LANG_CONFIG_PASSLOGIC_WINLOGON_MAX_RETRY ?></th>
		<td><?php echo $this->winMaxRetry ?></td>
		</tr>
		<tr>
		</table>
		<?php
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<?php // <<< START ONLY PassLogic Authentication -------------------------------
if(in_array('PassLogic', $this->_authMethod)){ ?>
<tr><th colspan="2">&nbsp;</th></tr>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_PASSLOGIC?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_RANDVALIDPERIOD?></th>
	<td>
		<?php echo $this->_RandValidPeriod?> <?php echo LANG_CNT_SECONDS?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_OLDPASSCOUNT?></th>
	<td>
		<?php echo $this->_oldPassCount?>
	</td>
</tr>

<tr>
	<th rowspan="2"><?php echo LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP?></th>
	<td>
		<?php
		if ($this->_isPasschgTimeup=="false") {
			print LANG_CONFIG_UNLIMITED;
		} else {
			print $this->_passchgtimeupdays." ".LANG_CNT_DAYS;
		}
		?>
	</td>
</tr>

<tr>
	<td>
		<?php
		if ($this->_isPasschgTimeup == "false" || $this->_notice_passchg_hour == "--") {
			print "OFF&nbsp;:&nbsp;";
		} else {
			print $this->_notice_passchg_days_1 . "&nbsp;-&nbsp;" . $this->_notice_passchg_days_2 . "&nbsp;" . LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_DAYS_BEFORE_2 . "&nbsp;";
			print LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_EVERYDAY . "&nbsp;" . $this->_notice_passchg_hour . "&nbsp;";
			print LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_HOUR . "&nbsp;:&nbsp;";
		}
		print LANG_CONFIG_PASSLOGIC_PASSCHGTIMEUP_NOTICE_MAIL;
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_DISP_PASSLIMIT?></th>
	<td>
		<?php
			echo $this->dispPassLimit_arr[$this->dispPassLimit];
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_UPASSCHGFORCED?></th>
	<td>
		<?php echo $this->passchgforced_arr[$this->_passchgforced] ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_CHANGE_PASSWORD?></th>
	<td>
		<?php echo $this->enableChangePassword_arr[$this->_enableChangePassword] ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_REQUIRE_CURRENT_PASSWORD?></th>
	<td>
		<?php echo $this->requireCurrentPassword_arr[$this->_requireCurrentPassword] ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_MATRIX_SIZE?></th>
	<td>
		<?php echo LANG_CONFIG_MATRIX_ROW?> <?php echo $this->_matrixrow?>

		<?php echo LANG_CONFIG_MATRIX_COL?> <?php echo $this->_matrixcol?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_NOFIX_PASS?></th>
	<td>
		<?php echo LANG_CONFIG_MIN?> <?php echo $this->_minOtpLength?>

		<?php echo LANG_CONFIG_MAX?> <?php echo $this->_maxOtpLength?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_NOFIX_RANDOM_LENGTH?></th>
	<td>
		<?php echo $this->_randomOtpLength?><br>
		<?php echo $this->_simpleOtp ? "ON" : "OFF" ?>&nbsp;:&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_NOFIX_RANDOM_SIMPLE ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_FIX_PASS?></th>
	<td>
		<?php echo LANG_CONFIG_MIN?> <?php echo $this->_minPinLength?>
		<?php echo LANG_CONFIG_MAX?> <?php echo $this->_maxPinLength?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_FIX_RANDOM_LENGTH?></th>
	<td>
		<?php echo $this->_randomPinLength?>
	</td>
</tr>

<tr>
	<th rowspan="2"><?php echo LANG_CONFIG_PASSLOGIC_FORBIDDEN_PATTERNS?></th>
	<td>
		<?php echo $this->_traversable ? "ON" : "OFF" ?>&nbsp;:&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_TRAVERSABLE_PATTERNS ?><br>
		<?php echo $this->_restricted_patterns ? "ON" : "OFF" ?>&nbsp;:&nbsp;<?php echo LANG_CONFIG_PASSLOGIC_USE_ALL_BLOCKS ?>
	</td>
</tr>

<tr>
	<td>
		<?php echo LANG_CONFIG_PASSLOGIC_FORBIDDEN_PATTERNS_SUBTITLE ?><br>
		<?php
		if (count((array)$this->_forbiddenPatterns) > 0) {
			foreach ($this->_forbiddenPatterns as $key => $val) {
				if ($this->_delforbiddenPatterns[$key] ?? false) {
					print "<s>".$val."</s>";
				} else {
					print $val;
				}
				print "<br>\n";
			}
		}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_REMINDER ?></th>
	<td>
		<?php
			if($this->_passwordReminder){
				echo "ON";
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_WEBTOKEN ?></th>
	<td>
		<?php
			if($this->ifWebtoken){
				echo "ON";
			}else{
				echo "OFF";
			}
		?><br>
		<?php
			if($this->showPasschg == '1'){
				echo LANG_CONFIG_PASSLOGIC_WEBTOKEN_SHOWPASSCHG_DESC;
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_GUIDE ?></th>
	<td>
		<?php
			if($this->ifGuide){
				echo "ON";
			}else{
				echo "OFF";
			}
		?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT ?></th>
	<td>
		<?php if($this->_passclip_login_protect_check){ ?>
			<?php echo "ON";?>
			<br><br>
			<?php echo (LANG_CONFIG_PASSLOGIC_PASSCLIP_BIO . ":") . ($this->_passclip_login_protect_bio ?  "ON" : "OFF");?>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_URL . " : " . $this->_passclip_login_protect_url;?>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_SID . " : " . $this->_passclip_login_protect_sid;?>
			<br><br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_MAX_NUM_SLOT ?>
			<?php if($this->_passclip_max_num_slot_check){ ?>
				<?php echo "ON";?>
				<br><br>
				<?php echo LANG_CONFIG_PASSLOGIC_SLOT_COUNT . " : " . $this->_passclip_max_num_slot;?>
				<br>
				<?php echo LANG_CONFIG_PASSLOGIC_SLOT_API_URL . " : " . $this->_passclip_slot_api_url;?>
			<?php } else { ?>
				<?php echo "OFF";?>
			<?php } ?>
		<?php } else { ?>
			<?php echo "OFF";?>
		<?php } ?>
	</td>
</tr>
<?php } // ---------------------------- ONLY PassLogic Authentication END >>> ?>

<?php // <<< START ONLY PassClip Authentication --------------------------------
if(in_array('PassClip', $this->_authMethod)){ ?>
<tr><th colspan="2">&nbsp;</th></tr>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_PASSCLIP ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_SLOT_NAME ?></th>
	<td>
		<?php echo $this->_passclip_slot_name?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_DISPLAY_TYPE ?></th>
	<td>
		<?php echo $this->passclipDisplayType_arr[$this->_passclip_display_type] ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_TIMESTEP?></th>
	<td>
		<?php echo $this->_passclip_timestep?> <?php echo LANG_CNT_SECONDS?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_DIGITS ?></th>
	<td>
		<?php echo $this->_passclip_digits?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_MAX_NUM_SLOT ?></th>
	<td>
		<?php if($this->_passclip_max_num_slot_check){ ?>
			<?php echo "ON";?>
			<br><br>
			<?php echo LANG_CONFIG_PASSLOGIC_SLOT_COUNT . " : " . $this->_passclip_max_num_slot;?>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_SLOT_API_URL . " : " . $this->_passclip_slot_api_url;?>
		<?php } else { ?>
			<?php echo "OFF";?>
		<?php } ?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT ?></th>
	<td>
		<?php if($this->_passclip_login_protect_check){ ?>
			<?php echo "ON";?>
			<br><br>
			<?php echo (LANG_CONFIG_PASSLOGIC_PASSCLIP_BIO . ":") . ($this->_passclip_login_protect_bio ?  "ON" : "OFF");?>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_URL . " : " . $this->_passclip_login_protect_url;?>
			<br>
			<?php echo LANG_CONFIG_PASSLOGIC_PASSCLIP_LOGIN_PROTECT_SID . " : " . $this->_passclip_login_protect_sid;?>
		<?php } else { ?>
			<?php echo "OFF";?>
		<?php } ?>
	</td>
</tr>

<?php } // --------------------------------- ONLY PassClip Authentication END >>> ?>

<?php // <<< START ONLY TOTP Authentication ------------------------------------
if(in_array('TOTP', $this->_authMethod)){ ?>
<tr><th colspan="2">&nbsp;</th></tr>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_AUTH_TOTP?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_TOTP_TIMESHIFT1?></th>
	<td>
		<?php echo $this->_totpTimeShift1?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_PASSLOGIC_TOTP_TIMESHIFT2?></th>
	<td>
		<?php echo $this->_totpTimeShift2?>
	</td>
</tr>

<?php } // --------------------------------- ONLY TOTP Authentication END >>> ?>

<tr><th colspan="2">&nbsp;</th></tr>
</table>

<h4 class="configHeading"><?php echo LANG_USER_TAB_NOTICE ?></h4>
<!--UserInfo-->
<table>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_MAIL_ADDRESS_SETTINGS ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_FROM ?></th>
	<td>
		<?php echo $this->_mailFrom?><br>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_CC ?></th>
	<td>
		<?php echo $this->_mailCc?><br>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BCC ?></th>
	<td>
		<?php echo $this->_mailBcc ?><br>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSLOGIC_NEW_USER ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody)?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSCLIP_SECRET ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_secret?>
	</td>
</tr>

<?php // <<< START ONLY PassLogic Authentication -------------------------------
if(in_array('PassLogic', $this->_authMethod)){ ?>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSLOGIC_REISSUE ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_reissue?><br>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_reissue)?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSLOGIC_REMINDER ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_reminder?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_reminder)?>
	</td>
</tr>
<?php } // ---------------------------- ONLY PassLogic Authentication END >>> ?>

<?php // <<< START ONLY PassClip Authentication --------------------------------
if(in_array('PassClip', $this->_authMethod)){ ?>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_passclip?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_passclip)?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PASSCLIP_SECRET ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_secret?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_secret)?>
	</td>
</tr>
<?php } // ----------------------------- ONLY PassClip Authentication END >>> ?>

<?php // <<< START ONLY TOTP Authentication ------------------------------------
if(in_array('TOTP', $this->_authMethod)){ ?>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_TOTP_REPLACETOKEN ?></span></th>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_token?>
	</td>
</tr>

<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_token)?>
	</td>
</tr>

<?php } // --------------------------------- ONLY TOTP Authentication END >>> ?>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_ACTIVATE ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_activate?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_activate)?>
	</td>
</tr>

<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_PKI ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_pki?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_pki)?>
	</td>
</tr>

<?php if(in_array('PassLogic', $this->_authMethod)){ ?>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_EXPIRATION_DATE ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_passchg?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_passchg)?>
	</td>
</tr>
<?php } ?>
<tr>
	<th colspan="2"><span class="configHeadingSmall"><?php echo LANG_CONFIG_SUBTITLE_LOCKEDMAIL ?></span></th>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_SUBJECT ?></th>
	<td>
		<?php echo $this->_mailSubject_lockedmail?>
	</td>
</tr>
<tr>
	<th><?php echo LANG_CONFIG_SENDMAIL_BODY ?></th>
	<td>
		<?php echo nl2br($this->_mailBody_lockedmail)?>
	</td>
</tr>

<tr><th colspan="2">&nbsp;</th></tr>
</table>

<a href="policyList.php"><?php echo LANG_CNT_RETURN ?></a>

<?php include(TMPL_DIR."/html_footer.ihtml.php")?>
