#!/usr/bin/php
<?php
/**
 * restore.sh が作ったlockfile がある場合は exit 1
 */
require_once('/opt/passlogic/apps/lib/passlogic_lock.php');
if (PasslogicLock::cron_exists())
{
	$cmd = "echo log_activity userimport interrupted because restore.sh is in progress. | /opt/passlogic/apps/tools/pm.sh > /dev/null";
	exec($cmd);
	exit(1);
}

/**
 * settings
 */
require_once('/opt/passlogic/apps/lib/settings/global_init.php');
require_once(LIB_DIR . '/settings/server_setting.php');
require_once(LIB_DIR . '/settings/general_setting.php');
require_once(LIB_DIR . '/language.inc.php');

class userimport {

	// generated by 'fix-undefined-property@1.0.0' (ticket #1897) START
	public $basic_auth_param;
	public $cert;
	public $client_cert_enable;
	public $client_info;
	public $crypt;
	public $lock_file;
	public $notify_by_email;
	public $passlogic_config;
	public $passlogic_tenant;
	public $plau;
	public $plinc;
	public $plLog;
	public $set_column;
	public $skip_itemname;
	public $test_user_editable;
	public $validator;
	// generated by 'fix-undefined-property@1.0.0' (ticket #1897) END

	private string $csv_path = '';
	private string $config_path = '';
	private $language;
	private $general_settings;

	// パスワード情報取込フラグ有効の場合、既に暗号化されている項目
	// DB取り込み時に暗号化しない
	private $crypted_array = array(
		'p1',
		'passsetold',
		'password1',
		'password2',
		'password3',
		'password4',
		'password5',
		'adpassword',
		'secret',
		'token_pin',
		'passclip_pin'
	);

	// パスワード情報取込フラグ有効の場合、既存ユーザの以下の情報は更新しない
	private $non_edit_array = array(
		'p1',
		'passsetold',
		'passsetdate'
	);
	
	public function __construct($target_tenant) {
		$this->validator = new Validator();
		$this->plinc = new passlogicInc();
		$this->plau = new passlogic_api_util();
		$this->cert = new cert_util();
		$this->plLog = $this->plau->plLog;
		$this->passlogic_config = new passlogic_config(getPDO());
		$this->crypt = $this->plau->crypt;
		$this->passlogic_tenant = new passlogic_tenant(getPDO());

		$this->language = new Language();
		$this->general_settings = new general_setting();
		$this->general_settings->read_setting_for_tenant($target_tenant);
	
		// シグナルハンドラ設定
		pcntl_signal(SIGINT, [&$this, 'sig_handler']);	// Ctrl + C の割り込み
		pcntl_signal(SIGTERM, [&$this, 'sig_handler']);	// kill
		pcntl_async_signals(true);

		// ユーザIDの最大長(1-64以外の値を指定した場合の動作は保証しない)
		if (!defined('MAX_USER_ID_LENGTH')) {
			define('MAX_USER_ID_LENGTH', '30');
		}
		// ドメイン名の最大長(1-64以外の値を指定した場合の動作は保証しない)
		if (!defined('MAX_DOMAIN_NAME_LENGTH')) {
			define('MAX_DOMAIN_NAME_LENGTH', '20');
		}
	}

	public function main($import_file_path, $config_file_path, $host_ip, $client_ip, $client_ua, $domain_name, $target_tenant, $test_user_editable, $log_output_disable, $password_import_flag) {
		// ログ用の出力パラメータ
		$this->client_info = array(
		    'host_ip' => $host_ip,
		    'client_ip' => $client_ip,
		    'client_ua' => $client_ua
		);
		$this->plau->set_logoptions($this->client_info);

		// インポート前の設定
		$checked = $this->pre_check($import_file_path, $config_file_path, $domain_name, $target_tenant);
		if ($checked) {
			// プレチェック失敗=>インポートファイルとコンフィグファイルを削除
			// import_file delete.
			if (is_file($import_file_path)) {
				@unlink($import_file_path);
			}
			// config_file delete.
			if (is_file($config_file_path)) {
				@unlink($config_file_path);
			}
			$this->plLog->log($checked['code'], '', $domain_name, $target_tenant, $this->client_info);
			return false;
		}

		// シグナルハンドラでファイルを削除するため、csvと設定ファイルのパスをプロパティに保持する
		$this->csv_path = $import_file_path;
		$this->config_path = $config_file_path;

		// 設定ファイル読み込み
		$this->import_config($config_file_path);

		// インポート開始のログ出力
		if (!$log_output_disable) {
			$this->plLog->log('31301', '', $domain_name, $target_tenant, $this->client_info);
		}

		// テストユーザ編集可能フラグ
		$this->test_user_editable = $test_user_editable;

		// クライアント証明書発行可能フラグ
		$this->client_cert_enable = false;
		$tenant_config = $this->passlogic_tenant->get_tenant_data($target_tenant);
		if (isset($tenant_config['permission']['client_cert'])) {
			if ($tenant_config['permission']['client_cert'] === passlogic_tenant::AVAILABLE) {
				$this->client_cert_enable = true;
			}
		}

		// インポートのCSVファイル読み込み
		$this->import_csv($import_file_path, $target_tenant, $password_import_flag);

		// インポート終了のログ出力
		if (!$log_output_disable) {
			$this->plLog->log('31302', '', $domain_name, $target_tenant, $this->client_info);
		}

		// import_file delete.
		if (is_file($import_file_path)) {
			@unlink($import_file_path);
		}
		// config_file delete.
		if (is_file($config_file_path)) {
			@unlink($config_file_path);
		}

		//ロックファイル回収
		unlink($this->lock_file);
		return true;
	}

	/**
	 * 読込み前のチェック
	 * @param type $import_file_path
	 * @param type $config_file_path
	 * @param type $domain_name
	 * @param type $target_tenant
	 * @return エラーコード、もしくはNULL
	 */
	private function pre_check($import_file_path, $config_file_path, $domain_name, $target_tenant) {
		//入力ファイル確認
		if (!is_readable($import_file_path)) {
			return array('code' => '31304');
		}
		if (!is_readable($config_file_path)) {
			return array('code' => '31305');
		}

		// ロックファイル確認
		$lock_file_base = TMP_DIR . "/userimport.php.lock";
		$this->lock_file = $lock_file_base;
		if ($domain_name) {
			$this->lock_file .= "_" . $domain_name;
		}
		if ($target_tenant) {
			$this->lock_file .= ":" . $target_tenant;
		}

		// userimport.php.lock*ではじまるすべてのロックファイルを検査
		foreach (glob($lock_file_base . "*") as $file) {
			if (file_exists($file)) {
				// 5分以上処理が継続していなければロックファイル削除
				if ((time() - filemtime($file)) > 60 * 5) {
					unlink($file);
				} else {
					// ロックファイル名から、テナント、ドメインを取得
					$lock_tenant = '';
					$lock_domain = '';
					$tail = substr($file, strlen($lock_file_base)); // userimport.php.lock以降の追加パラメータ部分を取得
					// テナントがあれば取り出す
					if (strpos($tail, ':') !== false) {
						$lock_tenant = substr($tail, strpos($tail, ':') + 1);
						$tail = substr($tail, 0, strlen($tail) - strlen($lock_tenant) - 1);
					}
					// ドメインがあれば取り出す
					if (strpos($tail, '_') !== false) {
						$lock_domain = substr($tail, strpos($tail, '_') + 1);
					}

					// 同一テナントチェック
					if ($lock_tenant === $target_tenant) {
						// 同じテナント
						// ドメインチェック
						// １．現在のユーザインポートがドメイン指定していない
						// ２．実行中のユーザインポートがドメイン指定していない
						// ３．ドメイン指定が一致する
						if (!$domain_name || !$lock_domain || $lock_domain === $domain_name) {
							// 重複するのでuserimportは不可
							return array('code' => '31303');
						}
					}
				}
			}
		}

		// 多重起動防止用ロックファイル作成
		touch($this->lock_file);

		// 問題ないのでNULLを返す
		return NULL;
	}

	/**
	 * コンフィグファイルを読込む
	 */
	private function import_config($config_file_path) {
		// from passlogic-admin.
		$fp = fopen($config_file_path, 'rb');
		$this->skip_itemname = rtrim(fgets($fp, 4089));
		$second_line = rtrim(fgets($fp, 4089));
		$this->notify_by_email = (int)$second_line & 1;
		$this->basic_auth_param = (int)$second_line & 2;
		$this->set_column = preg_split("/,/", rtrim(fgets($fp, 4089)));
		fclose($fp);
	}

	private function import_csv($import_file_path, $target_tenant, $password_import_flag) {
		// インポートファイルの操作オブジェクト
		$fp = new SplFileObject($import_file_path);

		// 先頭行を項目名としてスキップ
		if ($this->skip_itemname) {
			$fp->fgets();
		}

		// 1行ずつ読み込み
		while (!$fp->eof()) {
			// 1行目読み込み
			// PHPのCSV取り込みは、SJISの『表』『圭』などの文字を取り込めないので、CSV変換前にUTF-8化する
			$line = mb_convert_encoding($fp->fgets(), "UTF-8", "sjis-win, UTF-8, eucjp-win, auto");
			if (!$line) {
				break;
			}
			$arr = str_getcsv($line);
			// データが配列じゃない（取り込み失敗）
			if (!is_array($arr)) {
				break;
			}

			// CSVのデータを並べ替え
			$param = NULL;
			$column_index = 0;
			foreach ($arr as $val) {
				if ($this->set_column[$column_index] ?? false) {
					$param[$this->set_column[$column_index]] = $val;
				}
				$column_index++;
			}

			// localドメインの追加
			if (!($param['domain'] ?? false)) {
				$param['domain'] = 'local';
			}

			// Default Policyの追加
			if (!($param['policy'] ?? false)) {
				$param['policy'] = 'Default Policy';
			}

			// テナントの強制追加（CSVでのtenantタグは未使用）
			$param['tenant'] = $target_tenant;

			// ユーザインポート開始
			$this->import_user($param, $password_import_flag);
		}
	}

	private function import_user(?array $param, $password_import_flag) {
		if (preg_match("/^d$/", $param['delflag'] ?? null)) {
			// 削除フラグのユーザを削除
			$user = new user_model($param['uid'], $param['domain'], $param['tenant']);

			// テストユーザが削除できるか調べる
			if (MULTI_TENANT && $this->test_user_editable != 1) {
				$user->select_from_db();
				$tmp_userdata = $user->get_userdata(array('test_user'));
				if ($tmp_userdata['test_user']) {
					// テストユーザを編集できないモードで取り込んでいるのに、テストユーザを編集しようとしていたので弾く。
					$this->plLog->log("30015", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
					return false;
				}
			}

			$ret = $this->plau->userdelete($user);
			if ($ret['code'] != '30003') {
				// 正常に追加できていない場合、そこで処理終了
				return false;
			}
			return true;
		} else {
			// ユーザの新規・編集
			// ユーザパラメータのValidation
			if (!$this->check_user_param($param)) {
				// パラメータのフォーマットに問題あり
				return false;
			}

			// Basic認証のparam1-10はBase64＋暗号化保存
			if ($this->basic_auth_param) {
				for ($i = 1; $i <= 10; $i++) {
					if ($param['param' . $i]) {
						$base64_passwd = base64_encode($param['param' . $i]);
						$param['param' . $i] = $this->crypt->encrypt_string($base64_passwd, $param['uid'] . $param['domain'] . $param['tenant']);
					}
				}
			}

			// ロック状態で登録する場合は現在のタイムスタンプも登録
			$locked = $param['locked'] ?? null;
			if ($locked == 1) {
				$param['lockedtime'] = $_SERVER['REQUEST_TIME'];
			}

			// ユーザの作成
			$user = new user_model($param['uid'], $param['domain'], $param['tenant']);

			// ハードウェアトークンのシリアル番号重複をチェック
			if (array_key_exists('token_serial', $param) && ($param['token_serial'] || $param['token_serial'] === '0')) {
				if ($user->check_token($param['token_serial'], false)) {
					$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
					return false;
				}
			}
			// 次ハードウェアトークンのシリアル番号重複をチェック
			if (array_key_exists('next_token_serial', $param) && ($param['next_token_serial'] || $param['next_token_serial'] === '0')) {
				if ($user->check_token($param['next_token_serial'], true)) {
					$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
					return false;
				}
			}
			// ハードウェアトークンのシリアル番号と次ハードウェアトークンのシリアル番号が重複する場合をチェック
			if (array_key_exists('token_serial', $param) && array_key_exists('next_token_serial', $param)) {
				if ($param['token_serial'] === $param['next_token_serial'] && $param['token_serial'] !== '') {
					$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
					return false;
				}
			}

			// ユーザの有無チェック
			if (!$user->is_exist()) {
				// 新規ユーザ

				// パスワード情報取込フラグが有効な場合
				if ($password_import_flag == '1') {

					// パラメータの詰込み
					foreach ($param as $key => $val) {
						if(in_array($key, $this->crypted_array)) {
							// 既に暗号化されている項目はそのまま設定
							$user->userdata[$key] = $val;
						} else {
							$user->set_value($key, $val);
						}
					}

					// 最終認証日時は初期化
					$user->userdata['lastauthdate'] = 0;
					// passlogic認証パスワード(p1)が設定されている場合のみ、
					// パスワード変更日付に現在時刻を設定
					if ($user->userdata['p1'] ?? false){
						$user->userdata['passsetdate'] = time();
					}

					$user->userdata['updated_at'] = time();
					$user->userdata['created_at'] = time();

				} else {
				// 通常時（パスワード情報取込フラグ無効の場合）

					// パラメータの詰込み
					foreach ($param as $key => $val) {
						$user->set_value($key, $val);
					}

					// テストユーザが新規作成できるか調べる
					if (MULTI_TENANT && $this->test_user_editable != 1) {
						$tmp_userdata = $user->get_userdata(array('test_user'));
						if ($tmp_userdata['test_user'] ?? false) {
							// テストユーザを編集できないモードで取り込んでいるのに、テストユーザを編集しようとしていたので弾く。
							$this->plLog->log("30014", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
							return false;
						}
					}

					$user->set_value('lastauthdate', 0);
					$user->set_value('updated_at', time());
					$user->set_value('created_at', time());

					// ポリシー取得
					$user->set_config();
					$config = $user->get_config();
					$auth_method = $config['authMethod'];

					// 認証方式ごとのパラメータセット
					if (in_array('PassLogic', $auth_method)) {
						$initialPattern = null;
						$initialPin = null;
						// csvにシークレットパターンのデータ項目あり
						if (array_key_exists('secret_pattern', $param)) {
							// 指定されている値をcreaternd関数用にコピー
							$initialPattern = $param['secret_pattern'];
						}
						// csvにスタティックパスワードのデータ項目あり
						if (array_key_exists('static_password', $param)) {
							// 指定されている値をcreaternd関数用にコピー
							$initialPin = $param['static_password'];
						}

						// どちらも未定義の場合は、シークレットパターンのみランダム発行
						if (!isset($initialPattern) and ! isset($initialPin)) {
							$initialPattern = 'random';
						}
						// シークレットパターンとスタティックパスワードの組合わせがランダム発行可能かチェック
						// なお、チェック用メソッド用に、判定対象の文字列を変換
						if ($initialPattern == 'random') {
							$secret_pattern0 = '__RANDOM_ASSIGN__';
						} else {
							$secret_pattern0 = $initialPattern;
						}
						if (Util::checkRandomCombination($secret_pattern0, $config['randomOtpLength'], NULL, $initialPin, $config['randomPinLength'])) {
							$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
							return false;
						}

						// シークレットパターン設定
						$user->set_p1($initialPattern, $initialPin);

						// ログインプロテクトが有効でシード（シークレット）がない			
						if ($config['passclip_login_protect_check'] === 'true') {
							// シード作成
							$user->set_secret();
						}
					}
					if (in_array('PassClip', $auth_method)) {
						// シード作成
						$user->set_secret();
					}
					if (in_array('TOTP', $auth_method)) {
						// 必須パラメータ(token_serial)が無ければ、エラー
						if (!(array_key_exists('token_serial', $param) && ($param['token_serial'] || $param['token_serial'] === '0'))) {
							$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
							return false;
						}
					}
				}

				// ユーザデータをDBに書き込み
				$ret = $this->plau->usercreate($user);
				if ($ret['code'] != '30001') {
					// 正常に追加できていない場合、そこで処理終了
					return false;
				}

				if ($ret && $this->notify_by_email) {
					$sendnotice_tmpl_type = 'new';
					$tmp_params = array(
					    "uid" => $param['uid'],
					    "domain" => $param['domain'],
					    "tenant" => $param['tenant'],
					    "type" => "user",
					    "num" => null,
					    "client_info" => $this->client_info
					);
					$this->plinc->sendnotice($sendnotice_tmpl_type, $tmp_params);
				}

				if (!MULTI_TENANT || strval($param['tenant']) == '' || $this->client_cert_enable) {
					// PKI自動発行ポリシーの場合
					if (($config['pkicheck'] ?? false) &&
						($config['autopki'] ?? false) &&
						($config['autopki_timing'] ?? false) != '1') {
						// 証明書自動発行
						$CL_set = $this->cert->generate_cert($param['uid'], $param['domain'], $param['tenant'], $param['uemail'], $config['autopki_CNSetting'], $config['autopki_expireDate']);
						if ($CL_set && $this->notify_by_email) {
							// PKI発行メール送信
							$tmp_params['serial'] = $CL_set['serial'];
							$this->plinc->sendnotice('pki', $tmp_params);
						}
					}
				}
			} else {
				// ユーザ既存情報取り込み
				$user->select_from_db();
				$before_test_user_flag = $user->get_userdata(array('test_user'));

				// 編集内容の有無フラグ
				$edit = false;

				// パスワード情報取込フラグが有効な場合
				if ($password_import_flag == '1') {

					// 編集パラメータの詰込み
					foreach ($param as $key => $val) {
						if (in_array($key, $this->non_edit_array)) {
							// PassLogic認証パスワード、パスワード変更履歴、パスワード変更日付は更新しない
							continue;
						} else if (in_array($key, $this->crypted_array)) {
							// 既に暗号化されている項目はそのまま設定
							$user->userdata[$key] = $val;
							$edit = true;
						} else {
							if ($user->set_value($key, $val, true) === true) {
								$edit = true;
							}
						}
					}
					// 最終認証日時は初期化
					$user->set_value('lastauthdate', 0);
					// 更新日時は現在時刻を設定
					$user->set_value('updated_at', time());

				} else {
					// 通常時（パスワード情報取込フラグ無効の場合）

					// テストユーザが編集できるか調べる
					if (MULTI_TENANT && $this->test_user_editable != 1) {
						if ($before_test_user_flag['test_user']) {
							// テストユーザを編集できないモードで取り込んでいるのに、テストユーザを編集しようとしていたので弾く。
							$this->plLog->log("30014", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
							return false;
						}
					}

					// 編集パラメータの詰込み
					foreach ($param as $key => $val) {
						if ($user->set_value($key, $val, true) === true) {
							$edit = true;
						}
					}
					$user->set_value('lastauthdate', 0);
					$user->set_value('updated_at', time());

					// テストユーザのフラグを変更しようとしていたら弾く
					$after_test_user_flag = $user->get_userdata(array('test_user'));
					if (!is_null($after_test_user_flag['test_user']) && $before_test_user_flag['test_user'] != $after_test_user_flag['test_user']) {
						$this->plLog->log("30016", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
						return false;
					}
				}

				// ユーザ更新
				if ($edit) {
					$ret = $this->plau->useredit($user);
					if ($ret['code'] != '30002') {
						// 正常に追加できていない場合、そこで処理終了
						return false;
					}
				}
			}

			//ロックファイル更新
			touch($this->lock_file);
		}
	}

// 未整理 -------------------------------------------------------------//

	/**
	 * validator main
	 */
	private function _validator($valid_arr, $param) {
		if (!is_array($param)) {
			return false;
		}

		$params = [];

		foreach ($valid_arr as $name => $valid) {
			if (!is_array($valid)) {
				return false;
			}
			foreach ($valid as $rule_name => $val) {
				$rule = $val['rule'];
				$ret = $this->validator->dispatchMethod($param["$name"] ?? null, $rule);

				if (!$ret[0]) {
					$params['error'] = $name . ":" . $rule_name;
					$params['code'] = $val['code'];
					break;
				}
			}
		}
		return $params;
	}

	private function check_user_param($param) {
		$valid_arr = array(
		    'uid' => array(
			'Required' => array(
			    'rule' => 'Required',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => array('Between', 1, MAX_USER_ID_LENGTH),
			    'code' => '31012',
			),
			'Userid' => array(
			    'rule' => 'Userid',
			    'code' => '31012',
			),
		    ),
		    'domain' => array(
			'Required' => array(
			    'rule' => 'Required',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => array('Between', 1, MAX_DOMAIN_NAME_LENGTH),
			    'code' => '31012',
			),
			'Domain' => array(
			    'rule' => 'Domain',
			    'code' => '31012',
			),
		    ),
		    'tenant' => array(
			'Between' => array(
			    'rule' => array('Between', 0, 50),
			    'code' => '31012',
			),
			'Tenant' => array(
			    'rule' => 'Tenant',
			    'code' => '31012',
			),
		    ),
		    'uemail' => array(
			'Email' => array(
			    'rule' => 'Email',
			    'code' => '31012',
			),
			'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
		    ),
			'uname' => array(
			'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
			),
			'employee_number' => array(
				'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
			),
			'section' => array(
			'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
			),
			'phone' => array(
				'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
			),
		    'policy' => array(
			'Policy' => array(
			    'rule' => 'Policy',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => array('Between', 0, 30),
			    'code' => '31012',
			),
		    ),
		    'group1' => array(
			'Group' => array(
			    'rule' => 'Groups',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => 'GroupsBetween',
			    'code' => '31012',
			),
		    ),
		    'group2' => array(
			'Group' => array(
			    'rule' => 'Groups',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => 'GroupsBetween',
			    'code' => '31012',
			),
		    ),
		    'group3' => array(
			'Group' => array(
			    'rule' => 'Groups',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => 'GroupsBetween',
			    'code' => '31012',
			),
		    ),
		    'group4' => array(
			'Group' => array(
			    'rule' => 'Groups',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => 'GroupsBetween',
			    'code' => '31012',
			),
		    ),
		    'group5' => array(
			'Group' => array(
			    'rule' => 'Groups',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => 'GroupsBetween',
			    'code' => '31012',
			),
		    ),
		    'udisabled' => array(
			'Regexp' => array(
			    'rule' => array('Regexp', "01"),
			    'code' => '31012',
			),
		    ),
		    'uexpiry' => array(
			'Date' => array(
			    'rule' => 'Date',
			    'code' => '31012',
			),
		    ),
		    'static_password' => array(
			'Fixpassword' => array(
			    'rule' => 'Fixpassword',
			    'code' => '31012',
			),
		    ),
		    'token_serial' => array(
			'PrintableString' => array(
			    'rule' => 'PrintableString',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => array('Between', 0, 32),
			    'code' => '31012',
			),
		    ),
		    'next_token_serial' => array(
			'PrintableString' => array(
			    'rule' => 'PrintableString',
			    'code' => '31012',
			),
			'Between' => array(
			    'rule' => array('Between', 0, 32),
			    'code' => '31012',
			),
		    ),
		    'token_pin' => array(
			'Fixpassword' => array(
				'rule' => 'Fixpassword',
				'code' => '31012',
			),
			'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
			),
			'passclip_pin' => array(
			'Fixpassword' => array(
				'rule' => 'Fixpassword',
				'code' => '31012',
			),
			'Between' => array(
				'rule' => array('Between', 0, 255),
				'code' => '31012',
			),
			),
		);

		// validator
		$error = $this->_validator($valid_arr, $param);
		$has_error = is_array($error) && count($error) > 0;
		if ($has_error) {
			$this->plLog->log($error['code'], $param['uid'], $param['domain'], $param['tenant'], array_merge($this->client_info, array('additional_message' => $error['error'])));
			return false;
		}

		// ドメイン名存在チェック
		if (!$this->passlogic_config->get_config('domain', $param['domain'], $param['tenant'])) {
			// 存在しなかった
			$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
			return false;
		}

		// ポリシー存在チェック
		if (!$this->passlogic_config->get_config('policy', $param['policy'], $param['tenant'])) {
			// 存在しなかった
			$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
			return false;
		}

		// シークレットパターンチェック
		$initialPattern = $param['initialPattern'] ?? null;
		if ($initialPattern) {
			if ($initialPattern !== 'random') {
				if (preg_match("/[^0-9,]+/", $initialPattern) || preg_match("/[,]{2,}/", $initialPattern)) {
					$this->plLog->log("31012", $param['uid'], $param['domain'], $param['tenant'], $this->client_info);
					return false;
				}
			}
		}

		return true;
	}

	/**
	 * シグナルハンドラ
	 * Ctrl + Cの割り込みとkillされた際に、作業ファイルを削除して異常終了する
	 */
	public function sig_handler() {
		// CSVファイル、設定ファイル、ロックファイル削除
		@unlink($this->csv_path);
		@unlink($this->config_path);
		unlink($this->lock_file);

		// 割り込み、強制終了のログ出力
		$this->plLog->log('31306', '', $domain_name, $target_tenant, $this->client_info);

		exit(1);
	}
}

/* --- 引数定義 --------------------------- */
// $argv[1] import file path
// $argv[2] config file path
// $argv[3] server host ip address
// $argv[4] client ip address
// $argv[5] client user agent
// $argv[6] domain name (LDAP ID同期実行時のドメイン指定)
// $argv[7] target_tenant
// $argv[8] テストユーザ編集可能フラグ(1:可能 それ以外:不可)
//   LDAP ID同期の場合、$argv[3]～$argv[5]は空文字列になる('')、
//   $client_ip, $client_uaは、inet型なので空文字列だとログ書込み時にエラーが出るので、
//   NULLで初期化(合わせて、$argv[5]もNULLで初期化)
// $argv[9] ログ出力抑止フラグ(1:無効 それ以外:不可)
//   LDAP ID同期の場合、開始、終了のログ出力を抑止する。
// $argv[10] パスワード情報取込フラグ（1:有効 それ以外:無効）
//   パスワード情報が含まれるCSVデータを取り込む

// スクリプト名($argv[0])を除いた引数の数
$argc_without_script_name = 10;
$_argv = array_map(
	function($i) use ($argv) { return $argv[$i] ?? null; },
	range(0, $argc_without_script_name)
);

$import_file_path = $_argv[1];
$config_file_path = $_argv[2];
$host_ip = ( $_argv[3] ? $_argv[3] : NULL );
$client_ip = ( $_argv[4] ? $_argv[4] : NULL );
$client_ua = ( $_argv[5] ? $_argv[5] : NULL );
$domain_name = $_argv[6] ? $_argv[6] : '';
$target_tenant = $_argv[7] ? $_argv[7] : '';
$test_user_editable = $_argv[8] ? $_argv[8] : 0;
$log_output_disable = $_argv[9] ? $_argv[9] : 0;
$password_import_flag = $_argv[10] ? $_argv[10] : 0;
$userimport = new userimport($target_tenant);
$userimport->main($import_file_path, $config_file_path, $host_ip, $client_ip, $client_ua, $domain_name, $target_tenant, $test_user_editable, $log_output_disable, $password_import_flag);

