#!/bin/sh
#
# (c) 2025 Passlogy Co., Ltd. All Rights Reserved.
#
# https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
# https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
# ----------
#引数説明
#${1}=subject
#${2}=startdate
#${3}=enddate
#${4}=filename

#初期設定
BASE_DIR=$(cd $(dirname $0)/..;pwd)
CERT_DIR=/opt/passlogic/tmp/cert_${4}
cd ${CERT_DIR}
. ${BASE_DIR}/setting/args.conf

#Root証明書用のDatabaseを作成（OpenSSLの仕様上必須のため）
mkdir certs
mkdir database
touch database/index.txt
echo '00' > database/serial

#証明書の作成
openssl req -new -key ${CERT_DIR}/${4}.key > ${CERT_DIR}/${4}.csr -subj "${1}"
openssl ca -in ${CERT_DIR}/${4}.csr -keyfile ${CERT_DIR}/${4}.key -out ${CERT_DIR}/${4}.crt\
 -startdate ${2} -enddate ${3} -selfsign -notext -batch -config ${BASE_DIR}/setting/openssl.conf -name rootCA -extfile ${BASE_DIR}/setting/rootCA_v3.txt -md ${md}

#後処理
rm -r certs
rm -r database
