<?php
/**
 * (c) 2025 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php
 class Language { public $language_cache; public $language_file; public $locale; var $classname = "Language"; var $session_name = "locale"; function __construct($arg=NULL) { $this->language_file = APPS_DIR."/passlogic-lang.xml"; $this->language_cache = "/opt/passlogic/tmp/passlogic-lang.cache"; $this->set($arg); } public static function create($locale = null): self { $ref = new ReflectionClass(self::class); $obj = $ref->newInstanceWithoutConstructor(); $obj->language_file = APPS_DIR."/passlogic-lang.xml"; $obj->language_cache = "/opt/passlogic/tmp/passlogic-lang.cache"; $obj->locale = is_null($locale) ? $obj->get_locale() : $locale; $obj->define($obj->locale); return $obj; } function get_langs() { return array("en"=>"English(en)", "ja"=>"日本語(ja)"); } function lang_select() { $langs = $this->get_langs(); $s = ''; $s .= "<form method=\"POST\" name=\"lang_select\" action=\"".PHP_SELF."\">\n"; $s .= "<select name=\"".$this->session_name."\">\n"; if (is_array($langs)) { foreach ($langs AS $value => $label) { $s .= sprintf('<option value="%s"', $value); if ($value == $this->locale) $s .= " selected"; $s .= ">$label</option>\n"; } } $s .= "</select>\n"; $s .= "<input type=\"submit\" name=\"submit\" />\n"; $s .= "</form>\n"; return $s; } function loadData($filename) { libxml_use_internal_errors(true); clearstatcache(); if(!file_exists($filename)){ print "file does not exist.<br>\n"; $error = false; return $error; } $xml = simplexml_load_string(file_get_contents($filename)); if (!$xml){ $errors = libxml_get_errors(); foreach ($errors as $error) { echo $this->display_xml_error($error, $xml); } libxml_clear_errors(); print "xml errort.<br>\n"; $error = false; return $error; } $xml_attr = $xml->file; $source_lang = (string) $xml_attr['source-language']; $target_lang = (string) $xml_attr['target-language']; libxml_use_internal_errors(false); $translationUnit = $xml->xpath('//trans-unit'); $translations = array(); foreach ($translationUnit as $unit){ $key = (string) $unit['id']; $translations[$key][$source_lang] = (string) $unit->source; $translations[$key][$target_lang] = (string) $unit->target; $translations[$key]['note'] = (string) $unit->note; } return $translations; } function display_xml_error($error, $xml){ $return = $xml[$error->line - 1] . "\n"; $return .= str_repeat('-', $error->column) . "^\n"; switch ($error->level) { case LIBXML_ERR_WARNING: $return .= "Warning $error->code: "; break; case LIBXML_ERR_ERROR: $return .= "Error $error->code: "; break; case LIBXML_ERR_FATAL: $return .= "Fatal Error $error->code: "; break; } $return .= trim($error->message) . "\n  Line: $error->line" . "\n  Column: $error->column"; if ($error->file) { $return .= "\n  File: $error->file"; } return "$return\n\n--------------------------------------------\n\n"; } function set($arg=NULL) { global $sess; $locale = null; if (filter_input(INPUT_POST, $this->session_name)) { $sess->register($this->session_name, filter_input(INPUT_POST, $this->session_name)); }elseif ($arg) { $sess->register($this->session_name, $arg); } if ($_SESSION[$this->session_name] ?? false) { if (preg_match('/en/', $_SESSION[$this->session_name])) { $locale = "en"; } else { $locale = "ja"; } } if(!$locale){ $lang_arr = explode(",", $_SERVER["HTTP_ACCEPT_LANGUAGE"] ?? null); if (preg_match('/ja/', $lang_arr[0])) { $locale = 'ja'; }else{ $locale = 'en'; } } $this->locale = $locale; clearstatcache(); $status = false; if (!file_exists($this->language_cache)) { $status = "cache"; } else { $stat_original = stat($this->language_file); $stat_cache = stat($this->language_cache); if (!$stat_original OR !$stat_cache){ print "could not parse the language file."; exit; } if($stat_cache[9] < $stat_original[9]) { $status = "cache"; } } if ($status == "cache") { $lang_arr = $this->loadData($this->language_file); if($lang_arr){ $fp = @fopen($this->language_cache, "w"); if ($fp) { fwrite($fp, serialize($lang_arr)); fclose($fp); } foreach($lang_arr as $key => $val){ define($key, rtrim($val[$locale])); } } else { print "could not parse the language file."; exit; } } else { $fp = fopen($this->language_cache, "r"); $cache = fread($fp, filesize($this->language_cache)); fclose($fp); $lang_arr = unserialize($cache); foreach($lang_arr as $key => $val){ define($key, rtrim($val[$locale])); } } } private function define($locale) { clearstatcache(); $status = false; if (!file_exists($this->language_cache)) { $status = "cache"; } else { $stat_original = stat($this->language_file); $stat_cache = stat($this->language_cache); if (!$stat_original OR !$stat_cache){ print "could not parse the language file."; exit; } if($stat_cache[9] < $stat_original[9]) { $status = "cache"; } } if ($status == "cache") { $lang_arr = $this->loadData($this->language_file); if($lang_arr){ $fp = @fopen($this->language_cache, "w"); if ($fp) { fwrite($fp, serialize($lang_arr)); fclose($fp); } } else { print "could not parse the language file."; exit; } } else { $fp = fopen($this->language_cache, "r"); $cache = fread($fp, filesize($this->language_cache)); fclose($fp); $lang_arr = unserialize($cache); } foreach($lang_arr as $key => $val){ if (!isset($val[$locale])) { echo "Could not find language resources for the locale '${locale}'." . PHP_EOL; exit; } define($key, rtrim($val[$locale])); } } function message_locale() { if ($this->locale === 'en') { return 'message'; } else { return 'message_' . $this->locale; } } private function get_locale () { $env_vars = ['LC_ALL', 'LC_MESSAGES', 'LANG']; $locale = null; foreach ($env_vars as $var) { $value = getenv($var); if ($value !== false && $value !== '') { $locale = $value; break; } } if ($locale === null) { return 'en'; } switch (true) { case $locale === 'C': case $locale === 'C.UTF-8': case $locale === 'POSIX': case strpos($locale, 'en_') === 0: return 'en'; case strpos($locale, 'ja_JP') === 0: return 'ja'; default: return 'en'; } } } 