<?php
/**
 * (c) 2025 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php
define('IP_NUM', '([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])'); define('IP_ADDRESS', '('.IP_NUM.'[.]){3}'.IP_NUM); define('IP_CIDR', '([1-9]|[1-2][0-9]|3[0-2])'); define('IP_MASK', '/^'.IP_ADDRESS.'(|(\/'.IP_ADDRESS.')|(\/'.IP_CIDR.'))$/'); define('IP_MASK2', '/^'.IP_ADDRESS.'$/'); require_once(LIB_DIR . '/groups.inc.php'); class Validator { var $class_name = "Validator"; function dispatchMethod($input_data, $rule = array()) { if (is_array($rule)) { $method = $rule[0]; $params = array_values($rule); $params[0] = $input_data; } else { $method = $rule; $params = array($input_data); } return call_user_func_array(array(&$this, $method), $params); } function Required($str) { $ret = preg_match("/[^\s]+/m", $str); $arr = array($ret, 'message' => 'Required.', 'message_ja' => '入力必須です'); return $arr; } function Regexp($str, $regexp) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[$regexp]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function minLength($str, $min) { if(strlen($str) < $min){ return array(0, 'message' => 'greater than of equal to '.$min.' length is required.', 'message_ja' => '文字数下限'.$min); } return array(1, ); } function maxLength($str, $max) { if(strlen($str) > $max){ return array(0, 'message' => 'less than or equal to '.$max.' length is required.', 'message_ja' => '文字数上限'.$max); } return array(1, ); } function Between($str, $min, $max) { if(strlen($str) > $max || strlen($str) < $min){ return array(0, 'message' => $min.' - '.$max.' length is required.', 'message_ja' => '文字数が'.$min.'-'.$max.'の範囲外.'); } return array(1,); } function BetweenValue($str, $min, $max) { if($str > $max || $str < $min){ return array(0, 'message' => $min.' - '.$max.' is required.', 'message_ja' => $min.' - '.$max.'の範囲外.'); } return array(1,); } function MinValue($str, $min) { if ($str === '' || $str < $min) { return array(0, 'message' => $min . ' or more', 'message_ja' => $min . ' 以上.'); } return array(1,); } function Length($str, $limit, $mb=false) { if (!$str && $str != '0') { return array(1); } if ($mb) { $len = mb_strlen($str); } else { $len = strlen($str); } if ($len != $limit) { return array(0, 'message' => $limit.' length is required.', 'message_ja' => $limit.'文字'); } return array(1); } function Numeric($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[0-9]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function AlphaNumeric($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[a-zA-Z0-9]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Alphabetic($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[a-zA-Z]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } public function PrintableString($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[a-zA-Z0-9\ \,\+\-\.\/\_\(\)\|]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function NaturalNumberString($str) { $ret1 = preg_match("/^[0-9]+$/", $str); if($ret1 === 0 || $ret1 === false) return array($ret1, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); $ret2 = strval(intval($str)) === $str; if(!$ret2) return array($ret2, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return array(1); } function Fixpassword($str) { if(!$str && $str != '0'){return array(1,);} if(!preg_match("/[^\w\.\(\)\{\}\[\]\~\-\_\/\'\!\#\$\^\?\@\%\+\`\&\*\=\|\;\"\<\>\\\\]/", $str)){ $arr = array(1,); }else{ $arr = array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } return $arr; } function Email($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})$/i", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function URL($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("|^([a-zA-Z][a-zA-Z0-9\+\-\.]*)\:\/\/([\-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)$|", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Authid($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[A-Za-z0-9\.\_\-\@\\\\]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Serviceid($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[A-Za-z0-9\.\_\-\@]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Userid($str) { if(!$str && $str != '0'){return array(1,);} if(preg_match("/[A-Za-z1-9\.\_\-]/", $str)===0){ return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } $ret = preg_match("/^[A-Za-z0-9\.\_\-]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Domain($str) { if(!$str && $str != '0'){return array(1,);} if($str=='0'){ return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } $ret = preg_match("/^[A-Za-z0-9\.\-]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Tenant($str) { if(!$str && $str != '0'){return array(1,);} if($str=='0'){ return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } if(in_array($str, array('.', '..'))){ return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } $ret = preg_match("/^[A-Za-z0-9\.\-\_]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Group($str) { if(!$str && $str != '0'){return array(1,);} if($str=='0'){ return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } $ret = preg_match("/^[A-Za-z0-9\_\-]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Groups($str) { if(!$str && $str != '0'){return array(1,);} if($str=='0'){ return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } $ret = preg_match("/^[A-Za-z0-9\_\-]+" . "(". Groups::get_group_delimiter() . "[A-Za-z0-9\_\-]+)*$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function GroupsBetween($str) { if(!$str && $str != '0'){return array(1,);} $max_len = Groups::get_group_name_max_length(); $delimiter = Groups::get_group_delimiter(); $groups = explode($delimiter, $str); foreach ($groups as $group) { if (strlen($group) > $max_len){ return array(0, 'message' => '1 - '.$max_len.' length is required.', 'message_ja' => '文字数が1-'.$max_len.'の範囲外.'); } } return array(1,); } function GroupsInActiveDirectory($str) { return $this->Groups($str); } function Policy($str) { if(!$str && $str !== "0"){return array(1,);} $ret = preg_match("/^[A-Za-z\_][A-Za-z0-9\_\-\ ]*$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function PasswdPattern($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^[A-Za-z0-9\.\_\@\-,]+$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function SecretPattern($str, $row, $col) { if ( (isset($str) && ($str == "__RANDOM_ASSIGN__")) || !isset($str) || ($str == '') ){ return array(1,); } $defpas = explode(",", preg_replace("/[,]+$/",'',$str)); $matrix1 = array("1", "2", "3", "4", "17", "18", "19", "20", "33", "34", "35", "36", "49", "50", "51", "52"); $matrix2 = array("5", "6", "7", "8", "21", "22", "23", "24", "37", "38", "39", "40", "53", "54", "55", "56"); $matrix3 = array("9", "10", "11", "12", "25", "26", "27", "28", "41", "42", "43", "44", "57", "58", "59", "60"); $matrix4 = array("13", "14", "15", "16", "29", "30", "31", "32", "45", "46", "47", "48", "61", "62", "63", "64"); $matrix = array(); for ($k = 1; $k <= $row; $k++) { $matrix = array_merge($matrix, array_slice(${"matrix" . $k}, 0, $col)); } foreach ($defpas as $value) { if (!in_array($value, $matrix)) { return array(0, 'message' => LANG_USER_SETTING_ERROR, 'message_ja' => LANG_USER_SETTING_ERROR); } } if ( count((array)$defpas) != count((array)array_unique($defpas)) ) { return array(0, 'message' => LANG_USER_CREATE_ERROR4, 'message_ja' => LANG_USER_CREATE_ERROR4); } return array(1,); } function Hostname($ip) { if(empty($ip)) return array(1,); $options_domain = array('flags' => FILTER_FLAG_HOSTNAME); $options_ip = array('flags' => FILTER_FLAG_IPV4); if(filter_var($ip, FILTER_VALIDATE_DOMAIN, $options_domain)) { return array(1,); } else if (filter_var($ip, FILTER_VALIDATE_IP, $options_ip)) { return array(1,); } return array(0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); } function IPAddress($ip) { if(!$ip){return array(1,);} $ip = preg_replace('/,/', ' ', $ip); $ip = preg_replace('/\s\s+/', ' ', $ip); $ips = explode(' ', $ip); if(!is_array($ips)){ $ips[] = $ip; } foreach($ips as $ip){ $ip = preg_replace('/\s/', '', $ip); $ret = preg_match(IP_MASK, $ip); if(!$ret){ $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } } return array(1,); } function IPAddress_single($ip) { if(!$ip){return array(1,);} $ret = preg_match(IP_MASK2, $ip); if (!$ret) { $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } return array(1,); } function Date($str) { if(!$str && $str != '0'){return array(1,);} $format = 'Ymd'; if (strpos($str, "/")) { $format = 'Y/m/d'; } else if (strpos($str, "-")) { $format = 'Y-m-d'; } try { $ret = (new DateTime($str))->format($format) == $str; } catch (Exception $e) { $ret = 0; } $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function MaxDate($str, $max_date){ if(!$str && $str != '0'){return array(1,);} try { $tmp = new DateTime($str); $max = new DateTime($max_date); if($tmp->getTimestamp() > $max->getTimestamp()){ return array(0, 'message' => 'Dates up to '.$max->format(('Y/m/d')).' can be entered.', 'message_ja' => $max->format(('Y/m/d')).'までの日付が入力できます'); }else{ return array(1, ); } } catch (Exception $e) { $ret = 0; } $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } function Time($str) { if(!$str && $str != '0'){return array(1,);} $ret = preg_match("/^([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$/", $str); $arr = array($ret, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です'); return $arr; } public function CountryCode($str) { if(!$str && $str != '0'){return array(1,);} $arr = array(1); $pieces = explode('|', $str); foreach ($pieces as $val) { if (!preg_match('/^[a-zA-Z]+$/', $val) or strlen($val) != 2) { $arr = array(0, 'message' => 'Country Code format is alpha-2.', 'message_ja' => '国/地域コードのフォーマットは英字2文字です。'); break; } } return $arr; } public function compare($str, $answer, $name_of_answer) { if($str !== $answer){ return array(0, 'message' => 'incorrect ' . $name_of_answer . '.', 'message_ja' => $name_of_answer . ' と一致しません。'); } return array(1, ); } public function WindowsUuid($uuid) { if($uuid === null) return [0, 'message' => 'Required.', 'message_ja' => '入力必須です']; if(!is_string($uuid)) return [0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です']; if(!preg_match('/^[a-fA-F0-9]{64}$/', $uuid)) return [0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です']; return [1]; } public function Menulinks($maybe_json, $texts, $allowed_icon_urls) { if (gettype($maybe_json) !== 'string') return [0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です']; $decoded = json_decode($maybe_json, true); if (json_last_error() !== JSON_ERROR_NONE) return [0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です']; $is_config_array = menu_links\data\config::isConfigArray($decoded); if (!$is_config_array) return [0, 'message' => 'invalid data.', 'message_ja' => '入力された値は不正です']; $has_too_many_groups = count($decoded) > 64; if ($has_too_many_groups) return [0, 'message' => $texts['groups.error.overGroupCount'], 'message_ja' => $texts['groups.error.overGroupCount']]; $has_too_short_group_name = array_reduce($decoded, fn($acc, $group) => $acc || mb_strlen($group['name']) < 1, false); if ($has_too_short_group_name) return [0, 'message' => $texts['group.error.emptyName'], 'message_ja' => $texts['group.error.emptyName']]; $has_too_long_group_name = array_reduce($decoded, fn($acc, $group) => $acc || mb_strlen($group['name']) > 256, false); if ($has_too_long_group_name) return [0, 'message' => $texts['group.error.overNameLength'], 'message_ja' => $texts['group.error.overNameLength']]; $group_names = array_map(fn($group) => $group['name'], $decoded); $has_duplicate_groups = count($group_names) !== count(array_unique($group_names)); if ($has_duplicate_groups) return [0, 'message' => $texts['group.error.duplicate'], 'message_ja' => $texts['group.error.duplicate']]; $links = array_merge(...array_map(fn($group) => $group['links'], $decoded)); $serialized_link_ids = array_map(fn($link) => "{$link['id']['type']}{$link['id']['name']}", $links); $has_duplicate_link_ids = count($serialized_link_ids) !== count(array_unique($serialized_link_ids)); if ($has_duplicate_link_ids) return [0, 'message' => $texts['link.error.duplicate'], 'message_ja' => $texts['link.error.duplicate']]; $icon_urls = array_map(fn($link) => $link['icon'], $links); $has_invalid_icon_url = !empty(array_diff($icon_urls, $allowed_icon_urls)); if ($has_invalid_icon_url) return [0, 'message' => $texts['link.error.hasInvalidIconUrl'], 'message_ja' => $texts['link.error.hasInvalidIconUrl']]; return [1]; } public function NbioKey($nbio_key, $is_auth_enabled) { if ($nbio_key === null) { return [ 0, 'message' => 'Parameter does not exist.', 'message_ja' => 'パラメータが存在しません。' ]; } if (!$is_auth_enabled && $nbio_key === '') { return [1]; } if (strlen($nbio_key) !== 32) { return [ 0, 'message' => 'The number of characters is incorrect. Please enter 32 characters.', 'message_ja' => '文字数が不正です。32文字で入力してください。' ]; } if (!preg_match('/^[0-9A-Za-z]+$/', $nbio_key)) { return [ 0, 'message' => 'Only alphanumeric characters (0-9, A-Z, a-z) are allowed.', 'message_ja' => '使用可能な文字種は、半角英数字(0-9, A-Z, a-z)のみです。' ]; } return [1]; } public function Outer_API_Key($outer_api_key) { if ($outer_api_key === null) { return [ 0, 'message' => 'Parameter does not exist.', 'message_ja' => 'パラメータが存在しません。' ]; } if (defined('OUTER_API_KEY_VALIDATOR') && is_string(OUTER_API_KEY_VALIDATOR)) { $test_match = @preg_match(OUTER_API_KEY_VALIDATOR, ''); if ($test_match === false && preg_last_error() !== PREG_NO_ERROR) { return [ 0, 'message' => 'invalid OUTER_API_KEY_VALIDATOR.', 'message_ja' => 'OUTER_API_KEY_VALIDATOR が不正です。' ]; } $outer_api_key_regexp = OUTER_API_KEY_VALIDATOR ; } else { $outer_api_key_regexp = '/^[A-Za-z0-9_-]{22,43}$/'; } if (!preg_match($outer_api_key_regexp, $outer_api_key)) { return [ 0, 'message' => 'Invalid API key.', 'message_ja' => '無効なAPIキーです。' ]; } return [1]; } } ?>
