#!/usr/bin/php
<?php
/**
 * (c) 2025 Passlogy Co., Ltd. All Rights Reserved.
 * 
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_ja.pdf
 * https://www.passlogy.com/pdf/PassLogicEndUserLicenseAgreem_ent_en.pdf
 */
?>
<?php
require_once('/opt/passlogic/apps/lib/settings/global_init.php');
require_once(LIB_DIR . '/language.inc.php');
require_once(LIB_DIR . '/validator.inc.php');

$lang = Language::create();
$passlogic_config = new passlogic_config(getPDO());
$server_config = $passlogic_config->get_config('server_config', 'default', '');
$server_vars = array_keys($server_config);

// $server_config 正規化
foreach ($server_vars as $val) {
	$server_config[$val] = !is_null($server_config[$val] ?? null) ? $server_config[$val] : '';
}


// APIキーをファイルから読み込み
$api_key_file = '/opt/passlogic/tmp/apikey';

// ファイルの存在確認
if (!file_exists($api_key_file)) {
	echo LANG_API_KEY_ERROR_FILE_NOT_FOUND . " (${api_key_file})" . PHP_EOL;
    exit(1);
}

// ファイルの読み取り権限確認
if (!is_readable($api_key_file)) {
	echo LANG_API_KEY_ERROR_FILE_NOT_READABLE . " (${api_key_file})" . PHP_EOL;
    exit(1);
}

// ファイル内容を読み込み
$api_key_content = @file_get_contents($api_key_file);
if ($api_key_content === false) {
	echo LANG_API_KEY_ERROR_FILE_READ_FAILED . " (${api_key_file})" . PHP_EOL;
    exit(1);
}

// API キーのバリデーション
$api_key = trim($api_key_content);
$val = new Validator();
$res = $val->Outer_API_Key($api_key);
if ($res[0] === 0) {
	echo $res[$lang->message_locale()] . PHP_EOL;
	exit(1);
}


$crypt = new Crypt();
$server_config['OUTER_API_KEY'] = $crypt->encrypt_string($api_key);
$res = $passlogic_config->set_config('server_config', 'default', '', $server_config);
if ($res) {
	echo LANG_API_KEY_SUCCESS_IMPORT . substr($api_key, 0, 10) . "...\n";	
} else {
	echo LANG_API_KEY_ERROR_IMPORT . PHP_EOL;
	exit(1);
}


